@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata pertaining to creation and last modification of the resource.
 * @property createdAt The timestamp of resource creation (UTC).
 * @property createdBy The identity that created the resource.
 * @property createdByType The type of identity that created the resource.
 * @property lastModifiedAt The timestamp of resource last modification (UTC)
 * @property lastModifiedBy The identity that last modified the resource.
 * @property lastModifiedByType The type of identity that last modified the resource.
 */
public data class SystemDataResponse(
    public val createdAt: String? = null,
    public val createdBy: String? = null,
    public val createdByType: String? = null,
    public val lastModifiedAt: String? = null,
    public val lastModifiedBy: String? = null,
    public val lastModifiedByType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsorchestrator.outputs.SystemDataResponse):
            SystemDataResponse = SystemDataResponse(
            createdAt = javaType.createdAt().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 -> args0 }).orElse(null),
            createdByType = javaType.createdByType().map({ args0 -> args0 }).orElse(null),
            lastModifiedAt = javaType.lastModifiedAt().map({ args0 -> args0 }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy().map({ args0 -> args0 }).orElse(null),
            lastModifiedByType = javaType.lastModifiedByType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
