@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.kotlin.outputs.KeyAttributesResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.KeyReleasePolicyResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.RotationPolicyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.keyvault.kotlin.outputs.KeyAttributesResponse.Companion.toKotlin as keyAttributesResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.KeyReleasePolicyResponse.Companion.toKotlin as keyReleasePolicyResponseToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.RotationPolicyResponse.Companion.toKotlin as rotationPolicyResponseToKotlin

/**
 * Builder for [Key].
 */
@PulumiTagMarker
public class KeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyArgs = KeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyArgsBuilder.() -> Unit) {
        val builder = KeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Key {
        val builtJavaResource = com.pulumi.azurenative.keyvault.Key(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Key(builtJavaResource)
    }
}

/**
 * The key resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var key = new AzureNative.KeyVault.Key("key", new()
 *     {
 *         KeyName = "sample-key-name",
 *         Properties = new AzureNative.KeyVault.Inputs.KeyPropertiesArgs
 *         {
 *             Kty = "RSA",
 *         },
 *         ResourceGroupName = "sample-group",
 *         VaultName = "sample-vault-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewKey(ctx, "key", &keyvault.KeyArgs{
 * 			KeyName: pulumi.String("sample-key-name"),
 * 			Properties: &keyvault.KeyPropertiesArgs{
 * 				Kty: pulumi.String("RSA"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-group"),
 * 			VaultName:         pulumi.String("sample-vault-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Key;
 * import com.pulumi.azurenative.keyvault.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key", KeyArgs.builder()
 *             .keyName("sample-key-name")
 *             .properties(Map.of("kty", "RSA"))
 *             .resourceGroupName("sample-group")
 *             .vaultName("sample-vault-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Key sample-key-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/keys/{keyName}
 * ```
 */
public class Key internal constructor(
    override val javaResource: com.pulumi.azurenative.keyvault.Key,
) : KotlinCustomResource(javaResource, KeyMapper) {
    /**
     * The attributes of the key.
     */
    public val attributes: Output<KeyAttributesResponse>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    keyAttributesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The elliptic curve name. For valid values, see JsonWebKeyCurveName.
     */
    public val curveName: Output<String>?
        get() = javaResource.curveName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val keyOps: Output<List<String>>?
        get() = javaResource.keyOps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The key size in bits. For example: 2048, 3072, or 4096 for RSA.
     */
    public val keySize: Output<Int>?
        get() = javaResource.keySize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The URI to retrieve the current version of the key.
     */
    public val keyUri: Output<String>
        get() = javaResource.keyUri().applyValue({ args0 -> args0 })

    /**
     * The URI to retrieve the specific version of the key.
     */
    public val keyUriWithVersion: Output<String>
        get() = javaResource.keyUriWithVersion().applyValue({ args0 -> args0 })

    /**
     * The type of the key. For valid values, see JsonWebKeyType.
     */
    public val kty: Output<String>?
        get() = javaResource.kty().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure location of the key vault resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the key vault resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key release policy in response. It will be used for both output and input. Omitted if empty
     */
    public val releasePolicy: Output<KeyReleasePolicyResponse>?
        get() = javaResource.releasePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keyReleasePolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key rotation policy in response. It will be used for both output and input. Omitted if empty
     */
    public val rotationPolicy: Output<RotationPolicyResponse>?
        get() = javaResource.rotationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> rotationPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Tags assigned to the key vault resource.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Resource type of the key vault resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KeyMapper : ResourceMapper<Key> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.keyvault.Key::class == javaResource::class

    override fun map(javaResource: Resource): Key = Key(
        javaResource as
            com.pulumi.azurenative.keyvault.Key,
    )
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Key].
 */
public suspend fun key(name: String, block: suspend KeyResourceBuilder.() -> Unit): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 */
public fun key(name: String): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
