@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.KeyvaultFunctions.getKeyPlain
import com.pulumi.azurenative.keyvault.KeyvaultFunctions.getMHSMPrivateEndpointConnectionPlain
import com.pulumi.azurenative.keyvault.KeyvaultFunctions.getManagedHsmPlain
import com.pulumi.azurenative.keyvault.KeyvaultFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.keyvault.KeyvaultFunctions.getSecretPlain
import com.pulumi.azurenative.keyvault.KeyvaultFunctions.getVaultPlain
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetKeyPlainArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetKeyPlainArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetMHSMPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetMHSMPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetManagedHsmPlainArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetManagedHsmPlainArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetVaultPlainArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.GetVaultPlainArgsBuilder
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetKeyResult
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetMHSMPrivateEndpointConnectionResult
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetManagedHsmResult
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetSecretResult
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetVaultResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetKeyResult.Companion.toKotlin as getKeyResultToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetMHSMPrivateEndpointConnectionResult.Companion.toKotlin as getMHSMPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetManagedHsmResult.Companion.toKotlin as getManagedHsmResultToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.azurenative.keyvault.kotlin.outputs.GetVaultResult.Companion.toKotlin as getVaultResultToKotlin

public object KeyvaultFunctions {
    /**
     * Gets the current version of the specified key from the specified key vault.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return The key resource.
     */
    public suspend fun getKey(argument: GetKeyPlainArgs): GetKeyResult =
        getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())

    /**
     * @see [getKey].
     * @param keyName The name of the key to be retrieved.
     * @param resourceGroupName The name of the resource group which contains the specified key vault.
     * @param vaultName The name of the vault which contains the key to be retrieved.
     * @return The key resource.
     */
    public suspend fun getKey(
        keyName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetKeyResult {
        val argument = GetKeyPlainArgs(
            keyName = keyName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getKeyResultToKotlin(getKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;keyvault&#46;kotlin&#46;inputs&#46;GetKeyPlainArgs].
     * @return The key resource.
     */
    public suspend fun getKey(argument: suspend GetKeyPlainArgsBuilder.() -> Unit): GetKeyResult {
        val builder = GetKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyResultToKotlin(getKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the managed HSM Pool.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return Private endpoint connection resource.
     */
    public suspend
    fun getMHSMPrivateEndpointConnection(argument: GetMHSMPrivateEndpointConnectionPlainArgs):
        GetMHSMPrivateEndpointConnectionResult =
        getMHSMPrivateEndpointConnectionResultToKotlin(getMHSMPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getMHSMPrivateEndpointConnection].
     * @param name Name of the managed HSM Pool
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm pool.
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @return Private endpoint connection resource.
     */
    public suspend fun getMHSMPrivateEndpointConnection(
        name: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetMHSMPrivateEndpointConnectionResult {
        val argument = GetMHSMPrivateEndpointConnectionPlainArgs(
            name = name,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getMHSMPrivateEndpointConnectionResultToKotlin(getMHSMPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMHSMPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;keyvault&#46;kotlin&#46;inputs&#46;GetMHSMPrivateEndpointConnectionPlainArgs].
     * @return Private endpoint connection resource.
     */
    public suspend
    fun getMHSMPrivateEndpointConnection(argument: suspend GetMHSMPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetMHSMPrivateEndpointConnectionResult {
        val builder = GetMHSMPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMHSMPrivateEndpointConnectionResultToKotlin(getMHSMPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified managed HSM Pool.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return Resource information with extended details.
     */
    public suspend fun getManagedHsm(argument: GetManagedHsmPlainArgs): GetManagedHsmResult =
        getManagedHsmResultToKotlin(getManagedHsmPlain(argument.toJava()).await())

    /**
     * @see [getManagedHsm].
     * @param name The name of the managed HSM Pool.
     * @param resourceGroupName Name of the resource group that contains the managed HSM pool.
     * @return Resource information with extended details.
     */
    public suspend fun getManagedHsm(name: String, resourceGroupName: String): GetManagedHsmResult {
        val argument = GetManagedHsmPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return getManagedHsmResultToKotlin(getManagedHsmPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedHsm].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;keyvault&#46;kotlin&#46;inputs&#46;GetManagedHsmPlainArgs].
     * @return Resource information with extended details.
     */
    public suspend fun getManagedHsm(argument: suspend GetManagedHsmPlainArgsBuilder.() -> Unit):
        GetManagedHsmResult {
        val builder = GetManagedHsmPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedHsmResultToKotlin(getManagedHsmPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the key vault.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return Private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName Name of the private endpoint connection associated with the key vault.
     * @param resourceGroupName Name of the resource group that contains the key vault.
     * @param vaultName The name of the key vault.
     * @return Private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;keyvault&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Private endpoint connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified secret.  NOTE: This API is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return Resource information with extended details.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param secretName The name of the secret.
     * @param vaultName The name of the vault.
     * @return Resource information with extended details.
     */
    public suspend fun getSecret(
        resourceGroupName: String,
        secretName: String,
        vaultName: String,
    ): GetSecretResult {
        val argument = GetSecretPlainArgs(
            resourceGroupName = resourceGroupName,
            secretName = secretName,
            vaultName = vaultName,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;keyvault&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return Resource information with extended details.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit):
        GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified Azure key vault.
     * Azure REST API version: 2023-02-01.
     * Other available API versions: 2018-02-14-preview, 2023-07-01.
     * @param argument null
     * @return Resource information with extended details.
     */
    public suspend fun getVault(argument: GetVaultPlainArgs): GetVaultResult =
        getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())

    /**
     * @see [getVault].
     * @param resourceGroupName The name of the Resource Group to which the vault belongs.
     * @param vaultName The name of the vault.
     * @return Resource information with extended details.
     */
    public suspend fun getVault(resourceGroupName: String, vaultName: String): GetVaultResult {
        val argument = GetVaultPlainArgs(
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())
    }

    /**
     * @see [getVault].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;keyvault&#46;kotlin&#46;inputs&#46;GetVaultPlainArgs].
     * @return Resource information with extended details.
     */
    public suspend fun getVault(argument: suspend GetVaultPlainArgsBuilder.() -> Unit):
        GetVaultResult {
        val builder = GetVaultPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVaultResultToKotlin(getVaultPlain(builtArgument.toJava()).await())
    }
}
