@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.kotlin.outputs.SecretPropertiesResponse
import com.pulumi.azurenative.keyvault.kotlin.outputs.SecretPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Secret].
 */
@PulumiTagMarker
public class SecretResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretArgs = SecretArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretArgsBuilder.() -> Unit) {
        val builder = SecretArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Secret {
        val builtJavaResource = com.pulumi.azurenative.keyvault.Secret(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Secret(builtJavaResource)
    }
}

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a secret
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secret = new AzureNative.KeyVault.Secret("secret", new()
 *     {
 *         Properties = new AzureNative.KeyVault.Inputs.SecretPropertiesArgs
 *         {
 *             Value = "secret-value",
 *         },
 *         ResourceGroupName = "sample-group",
 *         SecretName = "secret-name",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := keyvault.NewSecret(ctx, "secret", &keyvault.SecretArgs{
 * 			Properties: &keyvault.SecretPropertiesArgs{
 * 				Value: pulumi.String("secret-value"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sample-group"),
 * 			SecretName:        pulumi.String("secret-name"),
 * 			VaultName:         pulumi.String("sample-vault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Secret;
 * import com.pulumi.azurenative.keyvault.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secret = new Secret("secret", SecretArgs.builder()
 *             .properties(Map.of("value", "secret-value"))
 *             .resourceGroupName("sample-group")
 *             .secretName("secret-name")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Secret secret-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/secrets/{secretName}
 * ```
 */
public class Secret internal constructor(
    override val javaResource: com.pulumi.azurenative.keyvault.Secret,
) : KotlinCustomResource(javaResource, SecretMapper) {
    /**
     * Azure location of the key vault resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the key vault resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the secret
     */
    public val properties: Output<SecretPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Tags assigned to the key vault resource.
     */
    public val tags: Output<Map<String, String>>
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Resource type of the key vault resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecretMapper : ResourceMapper<Secret> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.keyvault.Secret::class == javaResource::class

    override fun map(javaResource: Resource): Secret = Secret(
        javaResource as
            com.pulumi.azurenative.keyvault.Secret,
    )
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Secret].
 */
public suspend fun secret(name: String, block: suspend SecretResourceBuilder.() -> Unit): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secret(name: String): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    return builder.build()
}
