@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.VaultArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.inputs.VaultPropertiesArgs
import com.pulumi.azurenative.keyvault.kotlin.inputs.VaultPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource information with extended details.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2018-02-14-preview, 2023-07-01.
 * ## Example Usage
 * ### Create a new vault or update an existing vault
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.KeyVault.Inputs.AccessPolicyEntryArgs
 *                 {
 *                     ObjectId = "00000000-0000-0000-0000-000000000000",
 *                     Permissions = new AzureNative.KeyVault.Inputs.PermissionsArgs
 *                     {
 *                         Certificates = new[]
 *                         {
 *                             "get",
 *                             "list",
 *                             "delete",
 *                             "create",
 *                             "import",
 *                             "update",
 *                             "managecontacts",
 *                             "getissuers",
 *                             "listissuers",
 *                             "setissuers",
 *                             "deleteissuers",
 *                             "manageissuers",
 *                             "recover",
 *                             "purge",
 *                         },
 *                         Keys = new[]
 *                         {
 *                             "encrypt",
 *                             "decrypt",
 *                             "wrapKey",
 *                             "unwrapKey",
 *                             "sign",
 *                             "verify",
 *                             "get",
 *                             "list",
 *                             "create",
 *                             "update",
 *                             "import",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge",
 *                         },
 *                         Secrets = new[]
 *                         {
 *                             "get",
 *                             "list",
 *                             "set",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge",
 *                         },
 *                     },
 *                     TenantId = "00000000-0000-0000-0000-000000000000",
 *                 },
 *             },
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             PublicNetworkAccess = "Enabled",
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = "A",
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * Location: pulumi.String("westus"),
 * Properties: keyvault.VaultPropertiesResponse{
 * AccessPolicies: keyvault.AccessPolicyEntryArray{
 * interface{}{
 * ObjectId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * Permissions: &keyvault.PermissionsArgs{
 * Certificates: pulumi.StringArray{
 * pulumi.String("get"),
 * pulumi.String("list"),
 * pulumi.String("delete"),
 * pulumi.String("create"),
 * pulumi.String("import"),
 * pulumi.String("update"),
 * pulumi.String("managecontacts"),
 * pulumi.String("getissuers"),
 * pulumi.String("listissuers"),
 * pulumi.String("setissuers"),
 * pulumi.String("deleteissuers"),
 * pulumi.String("manageissuers"),
 * pulumi.String("recover"),
 * pulumi.String("purge"),
 * },
 * Keys: pulumi.StringArray{
 * pulumi.String("encrypt"),
 * pulumi.String("decrypt"),
 * pulumi.String("wrapKey"),
 * pulumi.String("unwrapKey"),
 * pulumi.String("sign"),
 * pulumi.String("verify"),
 * pulumi.String("get"),
 * pulumi.String("list"),
 * pulumi.String("create"),
 * pulumi.String("update"),
 * pulumi.String("import"),
 * pulumi.String("delete"),
 * pulumi.String("backup"),
 * pulumi.String("restore"),
 * pulumi.String("recover"),
 * pulumi.String("purge"),
 * },
 * Secrets: pulumi.StringArray{
 * pulumi.String("get"),
 * pulumi.String("list"),
 * pulumi.String("set"),
 * pulumi.String("delete"),
 * pulumi.String("backup"),
 * pulumi.String("restore"),
 * pulumi.String("recover"),
 * pulumi.String("purge"),
 * },
 * },
 * TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * },
 * },
 * EnabledForDeployment: pulumi.Bool(true),
 * EnabledForDiskEncryption: pulumi.Bool(true),
 * EnabledForTemplateDeployment: pulumi.Bool(true),
 * PublicNetworkAccess: pulumi.String("Enabled"),
 * Sku: &keyvault.SkuArgs{
 * Family: pulumi.String("A"),
 * Name: keyvault.SkuNameStandard,
 * },
 * TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * },
 * ResourceGroupName: pulumi.String("sample-resource-group"),
 * VaultName: pulumi.String("sample-vault"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("accessPolicies", Map.ofEntries(
 *                     Map.entry("objectId", "00000000-0000-0000-0000-000000000000"),
 *                     Map.entry("permissions", Map.ofEntries(
 *                         Map.entry("certificates",
 *                             "get",
 *                             "list",
 *                             "delete",
 *                             "create",
 *                             "import",
 *                             "update",
 *                             "managecontacts",
 *                             "getissuers",
 *                             "listissuers",
 *                             "setissuers",
 *                             "deleteissuers",
 *                             "manageissuers",
 *                             "recover",
 *                             "purge"),
 *                         Map.entry("keys",
 *                             "encrypt",
 *                             "decrypt",
 *                             "wrapKey",
 *                             "unwrapKey",
 *                             "sign",
 *                             "verify",
 *                             "get",
 *                             "list",
 *                             "create",
 *                             "update",
 *                             "import",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge"),
 *                         Map.entry("secrets",
 *                             "get",
 *                             "list",
 *                             "set",
 *                             "delete",
 *                             "backup",
 *                             "restore",
 *                             "recover",
 *                             "purge")
 *                     )),
 *                     Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *                 )),
 *                 Map.entry("enabledForDeployment", true),
 *                 Map.entry("enabledForDiskEncryption", true),
 *                 Map.entry("enabledForTemplateDeployment", true),
 *                 Map.entry("publicNetworkAccess", "Enabled"),
 *                 Map.entry("sku", Map.ofEntries(
 *                     Map.entry("family", "A"),
 *                     Map.entry("name", "standard")
 *                 )),
 *                 Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *             ))
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a vault with network acls
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.KeyVault.Vault("vault", new()
 *     {
 *         Location = "westus",
 *         Properties = new AzureNative.KeyVault.Inputs.VaultPropertiesArgs
 *         {
 *             EnabledForDeployment = true,
 *             EnabledForDiskEncryption = true,
 *             EnabledForTemplateDeployment = true,
 *             NetworkAcls = new AzureNative.KeyVault.Inputs.NetworkRuleSetArgs
 *             {
 *                 Bypass = "AzureServices",
 *                 DefaultAction = "Deny",
 *                 IpRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "124.56.78.91",
 *                     },
 *                     new AzureNative.KeyVault.Inputs.IPRuleArgs
 *                     {
 *                         Value = "'10.91.4.0/24'",
 *                     },
 *                 },
 *                 VirtualNetworkRules = new[]
 *                 {
 *                     new AzureNative.KeyVault.Inputs.VirtualNetworkRuleArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1",
 *                     },
 *                 },
 *             },
 *             Sku = new AzureNative.KeyVault.Inputs.SkuArgs
 *             {
 *                 Family = "A",
 *                 Name = AzureNative.KeyVault.SkuName.Standard,
 *             },
 *             TenantId = "00000000-0000-0000-0000-000000000000",
 *         },
 *         ResourceGroupName = "sample-resource-group",
 *         VaultName = "sample-vault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/keyvault/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := keyvault.NewVault(ctx, "vault", &keyvault.VaultArgs{
 * Location: pulumi.String("westus"),
 * Properties: keyvault.VaultPropertiesResponse{
 * EnabledForDeployment: pulumi.Bool(true),
 * EnabledForDiskEncryption: pulumi.Bool(true),
 * EnabledForTemplateDeployment: pulumi.Bool(true),
 * NetworkAcls: interface{}{
 * Bypass: pulumi.String("AzureServices"),
 * DefaultAction: pulumi.String("Deny"),
 * IpRules: keyvault.IPRuleArray{
 * &keyvault.IPRuleArgs{
 * Value: pulumi.String("124.56.78.91"),
 * },
 * &keyvault.IPRuleArgs{
 * Value: pulumi.String("'10.91.4.0/24'"),
 * },
 * },
 * VirtualNetworkRules: keyvault.VirtualNetworkRuleArray{
 * &keyvault.VirtualNetworkRuleArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1"),
 * },
 * },
 * },
 * Sku: &keyvault.SkuArgs{
 * Family: pulumi.String("A"),
 * Name: keyvault.SkuNameStandard,
 * },
 * TenantId: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * },
 * ResourceGroupName: pulumi.String("sample-resource-group"),
 * VaultName: pulumi.String("sample-vault"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.keyvault.Vault;
 * import com.pulumi.azurenative.keyvault.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("westus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("enabledForDeployment", true),
 *                 Map.entry("enabledForDiskEncryption", true),
 *                 Map.entry("enabledForTemplateDeployment", true),
 *                 Map.entry("networkAcls", Map.ofEntries(
 *                     Map.entry("bypass", "AzureServices"),
 *                     Map.entry("defaultAction", "Deny"),
 *                     Map.entry("ipRules",
 *                         Map.of("value", "124.56.78.91"),
 *                         Map.of("value", "'10.91.4.0/24'")),
 *                     Map.entry("virtualNetworkRules", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1"))
 *                 )),
 *                 Map.entry("sku", Map.ofEntries(
 *                     Map.entry("family", "A"),
 *                     Map.entry("name", "standard")
 *                 )),
 *                 Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *             ))
 *             .resourceGroupName("sample-resource-group")
 *             .vaultName("sample-vault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:Vault sample-vault /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}
 * ```
 * @property location The supported Azure location where the key vault should be created.
 * @property properties Properties of the vault
 * @property resourceGroupName The name of the Resource Group to which the server belongs.
 * @property tags The tags that will be assigned to the key vault.
 * @property vaultName Name of the vault
 */
public data class VaultArgs(
    public val location: Output<String>? = null,
    public val properties: Output<VaultPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.VaultArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.VaultArgs =
        com.pulumi.azurenative.keyvault.VaultArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultArgs].
 */
@PulumiTagMarker
public class VaultArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<VaultPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value The supported Azure location where the key vault should be created.
     */
    @JvmName("mbiisugdarqwoifc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Properties of the vault
     */
    @JvmName("xyfhecwahongrmnm")
    public suspend fun properties(`value`: Output<VaultPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Resource Group to which the server belongs.
     */
    @JvmName("cukkqwlnlennbejo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags that will be assigned to the key vault.
     */
    @JvmName("xishmhjspcqeythu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the vault
     */
    @JvmName("kqeijowycdapgeis")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The supported Azure location where the key vault should be created.
     */
    @JvmName("snijnxvxrhfpxvlg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Properties of the vault
     */
    @JvmName("hiwgttgsroxtijyb")
    public suspend fun properties(`value`: VaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the vault
     */
    @JvmName("exeylrahcdrtqvqb")
    public suspend fun properties(argument: suspend VaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Resource Group to which the server belongs.
     */
    @JvmName("euydhihduanpwmwu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags that will be assigned to the key vault.
     */
    @JvmName("ccyudxrvoqsjgmqq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags that will be assigned to the key vault.
     */
    @JvmName("dfffufudnqbxpjun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the vault
     */
    @JvmName("xvdjjrmjtvxbmjxj")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): VaultArgs = VaultArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
