@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * SKU name to specify whether the key vault is a standard vault or a premium vault.
 */
public enum class SkuName(
    public val javaValue: com.pulumi.azurenative.keyvault.enums.SkuName,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.enums.SkuName> {
    Standard(com.pulumi.azurenative.keyvault.enums.SkuName.Standard),
    Premium(com.pulumi.azurenative.keyvault.enums.SkuName.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.keyvault.enums.SkuName = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.enums.SkuName): SkuName =
            SkuName.values().first { it.javaValue == javaType }
    }
}
