@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.GetMHSMPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the managed HSM Pool
 * @property privateEndpointConnectionName Name of the private endpoint connection associated with the managed hsm pool.
 * @property resourceGroupName Name of the resource group that contains the managed HSM pool.
 */
public data class GetMHSMPrivateEndpointConnectionPlainArgs(
    public val name: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.GetMHSMPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.keyvault.inputs.GetMHSMPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.keyvault.inputs.GetMHSMPrivateEndpointConnectionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMHSMPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetMHSMPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the managed HSM Pool
     */
    @JvmName("qhmuinbqbkejqbwk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the private endpoint connection associated with the managed hsm pool.
     */
    @JvmName("ohedliswnkvdurbr")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Name of the resource group that contains the managed HSM pool.
     */
    @JvmName("ohsmiwdwdribbupg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMHSMPrivateEndpointConnectionPlainArgs =
        GetMHSMPrivateEndpointConnectionPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
