@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.GetManagedHsmPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the managed HSM Pool.
 * @property resourceGroupName Name of the resource group that contains the managed HSM pool.
 */
public data class GetManagedHsmPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.GetManagedHsmPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.GetManagedHsmPlainArgs =
        com.pulumi.azurenative.keyvault.inputs.GetManagedHsmPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedHsmPlainArgs].
 */
@PulumiTagMarker
public class GetManagedHsmPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the managed HSM Pool.
     */
    @JvmName("orgusraarynswwad")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Name of the resource group that contains the managed HSM pool.
     */
    @JvmName("fytefcwsknxllieo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedHsmPlainArgs = GetManagedHsmPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
