@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.KeyRotationPolicyAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expiryTime The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
 */
public data class KeyRotationPolicyAttributesArgs(
    public val expiryTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.KeyRotationPolicyAttributesArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.KeyRotationPolicyAttributesArgs =
        com.pulumi.azurenative.keyvault.inputs.KeyRotationPolicyAttributesArgs.builder()
            .expiryTime(expiryTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyRotationPolicyAttributesArgs].
 */
@PulumiTagMarker
public class KeyRotationPolicyAttributesArgsBuilder internal constructor() {
    private var expiryTime: Output<String>? = null

    /**
     * @param value The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
     */
    @JvmName("olrigkfgvmwcuttd")
    public suspend fun expiryTime(`value`: Output<String>) {
        this.expiryTime = value
    }

    /**
     * @param value The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
     */
    @JvmName("rcgjarsnfjegmukk")
    public suspend fun expiryTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiryTime = mapped
    }

    internal fun build(): KeyRotationPolicyAttributesArgs = KeyRotationPolicyAttributesArgs(
        expiryTime = expiryTime,
    )
}
