@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.MHSMVirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A rule governing the accessibility of a managed hsm pool from a specific virtual network.
 * @property id Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
 */
public data class MHSMVirtualNetworkRuleArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.MHSMVirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.MHSMVirtualNetworkRuleArgs =
        com.pulumi.azurenative.keyvault.inputs.MHSMVirtualNetworkRuleArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MHSMVirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class MHSMVirtualNetworkRuleArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     */
    @JvmName("grewbvtmxgpjsayn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
     */
    @JvmName("tlubcxcxaoqqtmdw")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): MHSMVirtualNetworkRuleArgs = MHSMVirtualNetworkRuleArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
