@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.PermissionsArgs.builder
import com.pulumi.azurenative.keyvault.kotlin.enums.CertificatePermissions
import com.pulumi.azurenative.keyvault.kotlin.enums.KeyPermissions
import com.pulumi.azurenative.keyvault.kotlin.enums.SecretPermissions
import com.pulumi.azurenative.keyvault.kotlin.enums.StoragePermissions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Permissions the identity has for keys, secrets, certificates and storage.
 * @property certificates Permissions to certificates
 * @property keys Permissions to keys
 * @property secrets Permissions to secrets
 * @property storage Permissions to storage accounts
 */
public data class PermissionsArgs(
    public val certificates: Output<List<Either<String, CertificatePermissions>>>? = null,
    public val keys: Output<List<Either<String, KeyPermissions>>>? = null,
    public val secrets: Output<List<Either<String, SecretPermissions>>>? = null,
    public val storage: Output<List<Either<String, StoragePermissions>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.PermissionsArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.PermissionsArgs =
        com.pulumi.azurenative.keyvault.inputs.PermissionsArgs.builder()
            .certificates(
                certificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .keys(
                keys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 ->
                            args0.let({ args0 -> args0.toJava() })
                        })
                    })
                }),
            )
            .secrets(
                secrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .storage(
                storage?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [PermissionsArgs].
 */
@PulumiTagMarker
public class PermissionsArgsBuilder internal constructor() {
    private var certificates: Output<List<Either<String, CertificatePermissions>>>? = null

    private var keys: Output<List<Either<String, KeyPermissions>>>? = null

    private var secrets: Output<List<Either<String, SecretPermissions>>>? = null

    private var storage: Output<List<Either<String, StoragePermissions>>>? = null

    /**
     * @param value Permissions to certificates
     */
    @JvmName("pnhydejrltqennbk")
    public suspend fun certificates(`value`: Output<List<Either<String, CertificatePermissions>>>) {
        this.certificates = value
    }

    @JvmName("dhhlklqgnfngyumq")
    public suspend fun certificates(vararg values: Output<Either<String, CertificatePermissions>>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values Permissions to certificates
     */
    @JvmName("ilxcpmhbgvgtwyhk")
    public suspend fun certificates(values: List<Output<Either<String, CertificatePermissions>>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value Permissions to keys
     */
    @JvmName("cjrninjwejltvwcs")
    public suspend fun keys(`value`: Output<List<Either<String, KeyPermissions>>>) {
        this.keys = value
    }

    @JvmName("sivxflasxrcyfxdc")
    public suspend fun keys(vararg values: Output<Either<String, KeyPermissions>>) {
        this.keys = Output.all(values.asList())
    }

    /**
     * @param values Permissions to keys
     */
    @JvmName("dkfksglumwyohawg")
    public suspend fun keys(values: List<Output<Either<String, KeyPermissions>>>) {
        this.keys = Output.all(values)
    }

    /**
     * @param value Permissions to secrets
     */
    @JvmName("arpldholwuvsayqs")
    public suspend fun secrets(`value`: Output<List<Either<String, SecretPermissions>>>) {
        this.secrets = value
    }

    @JvmName("lwkjbsuubmskygoa")
    public suspend fun secrets(vararg values: Output<Either<String, SecretPermissions>>) {
        this.secrets = Output.all(values.asList())
    }

    /**
     * @param values Permissions to secrets
     */
    @JvmName("kxftlukglagfjifj")
    public suspend fun secrets(values: List<Output<Either<String, SecretPermissions>>>) {
        this.secrets = Output.all(values)
    }

    /**
     * @param value Permissions to storage accounts
     */
    @JvmName("xpowjnwvqqsdymkk")
    public suspend fun storage(`value`: Output<List<Either<String, StoragePermissions>>>) {
        this.storage = value
    }

    @JvmName("lfyqbgbufypckepq")
    public suspend fun storage(vararg values: Output<Either<String, StoragePermissions>>) {
        this.storage = Output.all(values.asList())
    }

    /**
     * @param values Permissions to storage accounts
     */
    @JvmName("yuepasqvewlcxaei")
    public suspend fun storage(values: List<Output<Either<String, StoragePermissions>>>) {
        this.storage = Output.all(values)
    }

    /**
     * @param value Permissions to certificates
     */
    @JvmName("hkpqrpeetqfpjbye")
    public suspend fun certificates(`value`: List<Either<String, CertificatePermissions>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param values Permissions to certificates
     */
    @JvmName("uobpepsskyhrksmj")
    public suspend fun certificates(vararg values: Either<String, CertificatePermissions>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value Permissions to keys
     */
    @JvmName("mrcyetjvfqkqnxqm")
    public suspend fun keys(`value`: List<Either<String, KeyPermissions>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param values Permissions to keys
     */
    @JvmName("rrkkrwbyweseqxso")
    public suspend fun keys(vararg values: Either<String, KeyPermissions>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param value Permissions to secrets
     */
    @JvmName("mpoogoxnjuslseac")
    public suspend fun secrets(`value`: List<Either<String, SecretPermissions>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param values Permissions to secrets
     */
    @JvmName("pmbfdntovvnxsijl")
    public suspend fun secrets(vararg values: Either<String, SecretPermissions>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secrets = mapped
    }

    /**
     * @param value Permissions to storage accounts
     */
    @JvmName("rqarvjhkkyvcpepv")
    public suspend fun storage(`value`: List<Either<String, StoragePermissions>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param values Permissions to storage accounts
     */
    @JvmName("hqrsngnswksmeuph")
    public suspend fun storage(vararg values: Either<String, StoragePermissions>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    internal fun build(): PermissionsArgs = PermissionsArgs(
        certificates = certificates,
        keys = keys,
        secrets = secrets,
        storage = storage,
    )
}
