@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.inputs

import com.pulumi.azurenative.keyvault.inputs.SecretPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties of the secret
 * @property attributes The attributes of the secret.
 * @property contentType The content type of the secret.
 * @property value The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
 */
public data class SecretPropertiesArgs(
    public val attributes: Output<SecretAttributesArgs>? = null,
    public val contentType: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.keyvault.inputs.SecretPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.keyvault.inputs.SecretPropertiesArgs =
        com.pulumi.azurenative.keyvault.inputs.SecretPropertiesArgs.builder()
            .attributes(attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretPropertiesArgs].
 */
@PulumiTagMarker
public class SecretPropertiesArgsBuilder internal constructor() {
    private var attributes: Output<SecretAttributesArgs>? = null

    private var contentType: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The attributes of the secret.
     */
    @JvmName("oauttyelsebtbmjm")
    public suspend fun attributes(`value`: Output<SecretAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value The content type of the secret.
     */
    @JvmName("xhtcumcyyembsody")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
     */
    @JvmName("uoqtdpoopmoxlsrw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The attributes of the secret.
     */
    @JvmName("yaqrhnlqaiogaeli")
    public suspend fun attributes(`value`: SecretAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The attributes of the secret.
     */
    @JvmName("pfhiqjiknqvtobpt")
    public suspend fun attributes(argument: suspend SecretAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = SecretAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value The content type of the secret.
     */
    @JvmName("xquotlflhivuwvms")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
     */
    @JvmName("mcybhahjcrrteiwh")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SecretPropertiesArgs = SecretPropertiesArgs(
        attributes = attributes,
        contentType = contentType,
        `value` = `value`,
    )
}
