@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An identity that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
 * @property applicationId  Application ID of the client making request on behalf of a principal
 * @property objectId The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
 * @property permissions Permissions the identity has for keys, secrets and certificates.
 * @property tenantId The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
 */
public data class AccessPolicyEntryResponse(
    public val applicationId: String? = null,
    public val objectId: String,
    public val permissions: PermissionsResponse,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.AccessPolicyEntryResponse):
            AccessPolicyEntryResponse = AccessPolicyEntryResponse(
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId(),
            permissions = javaType.permissions().let({ args0 ->
                com.pulumi.azurenative.keyvault.kotlin.outputs.PermissionsResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId(),
        )
    }
}
