@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Private endpoint connection resource.
 * @property etag Modified whenever there is a change in the state of private endpoint connection.
 * @property id The Azure Resource Manager resource ID for the managed HSM Pool.
 * @property location The supported Azure location where the managed HSM Pool should be created.
 * @property name The name of the managed HSM Pool.
 * @property privateEndpoint Properties of the private endpoint object.
 * @property privateLinkServiceConnectionState Approval state of the private link connection.
 * @property provisioningState Provisioning state of the private endpoint connection.
 * @property sku SKU details
 * @property systemData Metadata pertaining to creation and last modification of the key vault resource.
 * @property tags Resource tags
 * @property type The resource type of the managed HSM Pool.
 */
public data class GetMHSMPrivateEndpointConnectionResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val privateEndpoint: MHSMPrivateEndpointResponse? = null,
    public val privateLinkServiceConnectionState: MHSMPrivateLinkServiceConnectionStateResponse? =
        null,
    public val provisioningState: String,
    public val sku: ManagedHsmSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.GetMHSMPrivateEndpointConnectionResult):
            GetMHSMPrivateEndpointConnectionResult = GetMHSMPrivateEndpointConnectionResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMPrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.MHSMPrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.ManagedHsmSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.keyvault.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
