@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU details
 * @property family SKU Family of the managed HSM Pool
 * @property name SKU of the managed HSM Pool
 */
public data class ManagedHsmSkuResponse(
    public val family: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.ManagedHsmSkuResponse):
            ManagedHsmSkuResponse = ManagedHsmSkuResponse(
            family = javaType.family(),
            name = javaType.name(),
        )
    }
}
