@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attributes The attributes of key rotation policy.
 * @property lifetimeActions The lifetimeActions for key rotation action.
 */
public data class RotationPolicyResponse(
    public val attributes: KeyRotationPolicyAttributesResponse? = null,
    public val lifetimeActions: List<LifetimeActionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.RotationPolicyResponse):
            RotationPolicyResponse = RotationPolicyResponse(
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.KeyRotationPolicyAttributesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lifetimeActions = javaType.lifetimeActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.LifetimeActionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
