@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the secret
 * @property attributes The attributes of the secret.
 * @property contentType The content type of the secret.
 * @property secretUri The URI to retrieve the current version of the secret.
 * @property secretUriWithVersion The URI to retrieve the specific version of the secret.
 * @property value The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
 */
public data class SecretPropertiesResponse(
    public val attributes: SecretAttributesResponse? = null,
    public val contentType: String? = null,
    public val secretUri: String,
    public val secretUriWithVersion: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.SecretPropertiesResponse):
            SecretPropertiesResponse = SecretPropertiesResponse(
            attributes = javaType.attributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.keyvault.kotlin.outputs.SecretAttributesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contentType = javaType.contentType().map({ args0 -> args0 }).orElse(null),
            secretUri = javaType.secretUri(),
            secretUriWithVersion = javaType.secretUriWithVersion(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
