@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property timeAfterCreate The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
 * @property timeBeforeExpiry The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
 */
public data class TriggerResponse(
    public val timeAfterCreate: String? = null,
    public val timeBeforeExpiry: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.TriggerResponse):
            TriggerResponse = TriggerResponse(
            timeAfterCreate = javaType.timeAfterCreate().map({ args0 -> args0 }).orElse(null),
            timeBeforeExpiry = javaType.timeBeforeExpiry().map({ args0 -> args0 }).orElse(null),
        )
    }
}
