@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A rule governing the accessibility of a vault from a specific virtual network.
 * @property id Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
 * @property ignoreMissingVnetServiceEndpoint Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
 */
public data class VirtualNetworkRuleResponse(
    public val id: String,
    public val ignoreMissingVnetServiceEndpoint: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.keyvault.outputs.VirtualNetworkRuleResponse):
            VirtualNetworkRuleResponse = VirtualNetworkRuleResponse(
            id = javaType.id(),
            ignoreMissingVnetServiceEndpoint = javaType.ignoreMissingVnetServiceEndpoint().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
