@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kotlin

import com.pulumi.azurenative.Provider
import com.pulumi.kotlin.KotlinProviderResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AzureNativeProvider].
 */
@PulumiTagMarker
public class AzureNativeProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProviderArgs = ProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProviderArgsBuilder.() -> Unit) {
        val builder = ProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AzureNativeProvider {
        val builtJavaResource = Provider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AzureNativeProvider(builtJavaResource)
    }
}

/**
 * The provider type for the native Azure package.
 */
public class AzureNativeProvider internal constructor(
    override val javaResource: Provider,
) : KotlinProviderResource(javaResource, AzureNativeProviderMapper)

public object AzureNativeProviderMapper : ResourceMapper<AzureNativeProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        Provider::class == javaResource::class

    override fun map(javaResource: Resource): AzureNativeProvider = AzureNativeProvider(
        javaResource
            as Provider,
    )
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureNativeProvider].
 */
public suspend fun azureNativeProvider(
    name: String,
    block: suspend AzureNativeProviderResourceBuilder.() -> Unit,
): AzureNativeProvider {
    val builder = AzureNativeProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureNativeProvider(name: String): AzureNativeProvider {
    val builder = AzureNativeProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
