@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin

import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.AzureBlobDefinitionResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.BucketDefinitionResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GitRepositoryDefinitionResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.KustomizationDefinitionResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ObjectStatusDefinitionResponse
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.AzureBlobDefinitionResponse.Companion.toKotlin as azureBlobDefinitionResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.BucketDefinitionResponse.Companion.toKotlin as bucketDefinitionResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.GitRepositoryDefinitionResponse.Companion.toKotlin as gitRepositoryDefinitionResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.KustomizationDefinitionResponse.Companion.toKotlin as kustomizationDefinitionResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ObjectStatusDefinitionResponse.Companion.toKotlin as objectStatusDefinitionResponseToKotlin
import com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [FluxConfiguration].
 */
@PulumiTagMarker
public class FluxConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FluxConfigurationArgs = FluxConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FluxConfigurationArgsBuilder.() -> Unit) {
        val builder = FluxConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FluxConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FluxConfiguration(builtJavaResource)
    }
}

/**
 * The Flux Configuration object returned in Get & Put response.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * Other available API versions: 2021-11-01-preview, 2022-01-01-preview.
 * ## Example Usage
 * ### Create Flux Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fluxConfiguration = new AzureNative.KubernetesConfiguration.FluxConfiguration("fluxConfiguration", new()
 *     {
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         FluxConfigurationName = "srs-fluxconfig",
 *         GitRepository = new AzureNative.KubernetesConfiguration.Inputs.GitRepositoryDefinitionArgs
 *         {
 *             HttpsCACert = "ZXhhbXBsZWNlcnRpZmljYXRl",
 *             RepositoryRef = new AzureNative.KubernetesConfiguration.Inputs.RepositoryRefDefinitionArgs
 *             {
 *                 Branch = "master",
 *             },
 *             SyncIntervalInSeconds = 600,
 *             TimeoutInSeconds = 600,
 *             Url = "https://github.com/Azure/arc-k8s-demo",
 *         },
 *         Kustomizations =
 *         {
 *             { "srs-kustomization1", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new() { },
 *                 Path = "./test/path",
 *                 PostBuild = new AzureNative.KubernetesConfiguration.Inputs.PostBuildDefinitionArgs
 *                 {
 *                     Substitute =
 *                     {
 *                         { "cluster_env", "prod" },
 *                         { "replica_count", "2" },
 *                     },
 *                     SubstituteFrom = new[]
 *                     {
 *                         new AzureNative.KubernetesConfiguration.Inputs.SubstituteFromDefinitionArgs
 *                         {
 *                             Kind = "ConfigMap",
 *                             Name = "cluster-test",
 *                             Optional = true,
 *                         },
 *                     },
 *                 },
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *                 Wait = true,
 *             } },
 *             { "srs-kustomization2", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new[]
 *                 {
 *                     "srs-kustomization1",
 *                 },
 *                 Path = "./other/test/path",
 *                 PostBuild = new AzureNative.KubernetesConfiguration.Inputs.PostBuildDefinitionArgs
 *                 {
 *                     SubstituteFrom = new[]
 *                     {
 *                         new AzureNative.KubernetesConfiguration.Inputs.SubstituteFromDefinitionArgs
 *                         {
 *                             Kind = "ConfigMap",
 *                             Name = "cluster-values",
 *                             Optional = true,
 *                         },
 *                         new AzureNative.KubernetesConfiguration.Inputs.SubstituteFromDefinitionArgs
 *                         {
 *                             Kind = "Secret",
 *                             Name = "secret-name",
 *                             Optional = false,
 *                         },
 *                     },
 *                 },
 *                 Prune = false,
 *                 RetryIntervalInSeconds = 600,
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *                 Wait = false,
 *             } },
 *         },
 *         Namespace = "srs-namespace",
 *         ReconciliationWaitDuration = "PT30M",
 *         ResourceGroupName = "rg1",
 *         Scope = "cluster",
 *         SourceKind = "GitRepository",
 *         Suspend = false,
 *         WaitForReconciliation = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewFluxConfiguration(ctx, "fluxConfiguration", &kubernetesconfiguration.FluxConfigurationArgs{
 * 			ClusterName:           pulumi.String("clusterName1"),
 * 			ClusterResourceName:   pulumi.String("connectedClusters"),
 * 			ClusterRp:             pulumi.String("Microsoft.Kubernetes"),
 * 			FluxConfigurationName: pulumi.String("srs-fluxconfig"),
 * 			GitRepository: kubernetesconfiguration.GitRepositoryDefinitionResponse{
 * 				HttpsCACert: pulumi.String("ZXhhbXBsZWNlcnRpZmljYXRl"),
 * 				RepositoryRef: &kubernetesconfiguration.RepositoryRefDefinitionArgs{
 * 					Branch: pulumi.String("master"),
 * 				},
 * 				SyncIntervalInSeconds: pulumi.Float64(600),
 * 				TimeoutInSeconds:      pulumi.Float64(600),
 * 				Url:                   pulumi.String("https://github.com/Azure/arc-k8s-demo"),
 * 			},
 * 			Kustomizations: kubernetesconfiguration.KustomizationDefinitionMap{
 * 				"srs-kustomization1": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn: pulumi.StringArray{},
 * 					Path:      pulumi.String("./test/path"),
 * 					PostBuild: &kubernetesconfiguration.PostBuildDefinitionArgs{
 * 						Substitute: pulumi.StringMap{
 * 							"cluster_env":   pulumi.String("prod"),
 * 							"replica_count": pulumi.String("2"),
 * 						},
 * 						SubstituteFrom: kubernetesconfiguration.SubstituteFromDefinitionArray{
 * 							&kubernetesconfiguration.SubstituteFromDefinitionArgs{
 * 								Kind:     pulumi.String("ConfigMap"),
 * 								Name:     pulumi.String("cluster-test"),
 * 								Optional: pulumi.Bool(true),
 * 							},
 * 						},
 * 					},
 * 					SyncIntervalInSeconds: pulumi.Float64(600),
 * 					TimeoutInSeconds:      pulumi.Float64(600),
 * 					Wait:                  pulumi.Bool(true),
 * 				},
 * 				"srs-kustomization2": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn: pulumi.StringArray{
 * 						pulumi.String("srs-kustomization1"),
 * 					},
 * 					Path: pulumi.String("./other/test/path"),
 * 					PostBuild: &kubernetesconfiguration.PostBuildDefinitionArgs{
 * 						SubstituteFrom: kubernetesconfiguration.SubstituteFromDefinitionArray{
 * 							&kubernetesconfiguration.SubstituteFromDefinitionArgs{
 * 								Kind:     pulumi.String("ConfigMap"),
 * 								Name:     pulumi.String("cluster-values"),
 * 								Optional: pulumi.Bool(true),
 * 							},
 * 							&kubernetesconfiguration.SubstituteFromDefinitionArgs{
 * 								Kind:     pulumi.String("Secret"),
 * 								Name:     pulumi.String("secret-name"),
 * 								Optional: pulumi.Bool(false),
 * 							},
 * 						},
 * 					},
 * 					Prune:                  pulumi.Bool(false),
 * 					RetryIntervalInSeconds: pulumi.Float64(600),
 * 					SyncIntervalInSeconds:  pulumi.Float64(600),
 * 					TimeoutInSeconds:       pulumi.Float64(600),
 * 					Wait:                   pulumi.Bool(false),
 * 				},
 * 			},
 * 			Namespace:                  pulumi.String("srs-namespace"),
 * 			ReconciliationWaitDuration: pulumi.String("PT30M"),
 * 			ResourceGroupName:          pulumi.String("rg1"),
 * 			Scope:                      pulumi.String("cluster"),
 * 			SourceKind:                 pulumi.String("GitRepository"),
 * 			Suspend:                    pulumi.Bool(false),
 * 			WaitForReconciliation:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fluxConfiguration = new FluxConfiguration("fluxConfiguration", FluxConfigurationArgs.builder()
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .fluxConfigurationName("srs-fluxconfig")
 *             .gitRepository(Map.ofEntries(
 *                 Map.entry("httpsCACert", "ZXhhbXBsZWNlcnRpZmljYXRl"),
 *                 Map.entry("repositoryRef", Map.of("branch", "master")),
 *                 Map.entry("syncIntervalInSeconds", 600),
 *                 Map.entry("timeoutInSeconds", 600),
 *                 Map.entry("url", "https://github.com/Azure/arc-k8s-demo")
 *             ))
 *             .kustomizations(Map.ofEntries(
 *                 Map.entry("srs-kustomization1", Map.ofEntries(
 *                     Map.entry("dependsOn", ),
 *                     Map.entry("path", "./test/path"),
 *                     Map.entry("postBuild", Map.ofEntries(
 *                         Map.entry("substitute", Map.ofEntries(
 *                             Map.entry("cluster_env", "prod"),
 *                             Map.entry("replica_count", "2")
 *                         )),
 *                         Map.entry("substituteFrom", Map.ofEntries(
 *                             Map.entry("kind", "ConfigMap"),
 *                             Map.entry("name", "cluster-test"),
 *                             Map.entry("optional", true)
 *                         ))
 *                     )),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600),
 *                     Map.entry("wait", true)
 *                 )),
 *                 Map.entry("srs-kustomization2", Map.ofEntries(
 *                     Map.entry("dependsOn", "srs-kustomization1"),
 *                     Map.entry("path", "./other/test/path"),
 *                     Map.entry("postBuild", Map.of("substituteFrom",
 *                         Map.ofEntries(
 *                             Map.entry("kind", "ConfigMap"),
 *                             Map.entry("name", "cluster-values"),
 *                             Map.entry("optional", true)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("kind", "Secret"),
 *                             Map.entry("name", "secret-name"),
 *                             Map.entry("optional", false)
 *                         ))),
 *                     Map.entry("prune", false),
 *                     Map.entry("retryIntervalInSeconds", 600),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600),
 *                     Map.entry("wait", false)
 *                 ))
 *             ))
 *             .namespace("srs-namespace")
 *             .reconciliationWaitDuration("PT30M")
 *             .resourceGroupName("rg1")
 *             .scope("cluster")
 *             .sourceKind("GitRepository")
 *             .suspend(false)
 *             .waitForReconciliation(true)
 *             .build());
 *     }
 * }
 * ```
 * ### Create Flux Configuration with Bucket Source Kind
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fluxConfiguration = new AzureNative.KubernetesConfiguration.FluxConfiguration("fluxConfiguration", new()
 *     {
 *         Bucket = new AzureNative.KubernetesConfiguration.Inputs.BucketDefinitionArgs
 *         {
 *             AccessKey = "fluxminiotest",
 *             BucketName = "flux",
 *             SyncIntervalInSeconds = 1000,
 *             TimeoutInSeconds = 1000,
 *             Url = "https://fluxminiotest.az.minio.io",
 *         },
 *         ClusterName = "clusterName1",
 *         ClusterResourceName = "connectedClusters",
 *         ClusterRp = "Microsoft.Kubernetes",
 *         FluxConfigurationName = "srs-fluxconfig",
 *         Kustomizations =
 *         {
 *             { "srs-kustomization1", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new() { },
 *                 Path = "./test/path",
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *             } },
 *             { "srs-kustomization2", new AzureNative.KubernetesConfiguration.Inputs.KustomizationDefinitionArgs
 *             {
 *                 DependsOn = new[]
 *                 {
 *                     "srs-kustomization1",
 *                 },
 *                 Path = "./other/test/path",
 *                 Prune = false,
 *                 RetryIntervalInSeconds = 600,
 *                 SyncIntervalInSeconds = 600,
 *                 TimeoutInSeconds = 600,
 *             } },
 *         },
 *         Namespace = "srs-namespace",
 *         ResourceGroupName = "rg1",
 *         Scope = "cluster",
 *         SourceKind = "Bucket",
 *         Suspend = false,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kubernetesconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kubernetesconfiguration.NewFluxConfiguration(ctx, "fluxConfiguration", &kubernetesconfiguration.FluxConfigurationArgs{
 * 			Bucket: &kubernetesconfiguration.BucketDefinitionArgs{
 * 				AccessKey:             pulumi.String("fluxminiotest"),
 * 				BucketName:            pulumi.String("flux"),
 * 				SyncIntervalInSeconds: pulumi.Float64(1000),
 * 				TimeoutInSeconds:      pulumi.Float64(1000),
 * 				Url:                   pulumi.String("https://fluxminiotest.az.minio.io"),
 * 			},
 * 			ClusterName:           pulumi.String("clusterName1"),
 * 			ClusterResourceName:   pulumi.String("connectedClusters"),
 * 			ClusterRp:             pulumi.String("Microsoft.Kubernetes"),
 * 			FluxConfigurationName: pulumi.String("srs-fluxconfig"),
 * 			Kustomizations: kubernetesconfiguration.KustomizationDefinitionMap{
 * 				"srs-kustomization1": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn:             pulumi.StringArray{},
 * 					Path:                  pulumi.String("./test/path"),
 * 					SyncIntervalInSeconds: pulumi.Float64(600),
 * 					TimeoutInSeconds:      pulumi.Float64(600),
 * 				},
 * 				"srs-kustomization2": &kubernetesconfiguration.KustomizationDefinitionArgs{
 * 					DependsOn: pulumi.StringArray{
 * 						pulumi.String("srs-kustomization1"),
 * 					},
 * 					Path:                   pulumi.String("./other/test/path"),
 * 					Prune:                  pulumi.Bool(false),
 * 					RetryIntervalInSeconds: pulumi.Float64(600),
 * 					SyncIntervalInSeconds:  pulumi.Float64(600),
 * 					TimeoutInSeconds:       pulumi.Float64(600),
 * 				},
 * 			},
 * 			Namespace:         pulumi.String("srs-namespace"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Scope:             pulumi.String("cluster"),
 * 			SourceKind:        pulumi.String("Bucket"),
 * 			Suspend:           pulumi.Bool(false),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration;
 * import com.pulumi.azurenative.kubernetesconfiguration.FluxConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fluxConfiguration = new FluxConfiguration("fluxConfiguration", FluxConfigurationArgs.builder()
 *             .bucket(Map.ofEntries(
 *                 Map.entry("accessKey", "fluxminiotest"),
 *                 Map.entry("bucketName", "flux"),
 *                 Map.entry("syncIntervalInSeconds", 1000),
 *                 Map.entry("timeoutInSeconds", 1000),
 *                 Map.entry("url", "https://fluxminiotest.az.minio.io")
 *             ))
 *             .clusterName("clusterName1")
 *             .clusterResourceName("connectedClusters")
 *             .clusterRp("Microsoft.Kubernetes")
 *             .fluxConfigurationName("srs-fluxconfig")
 *             .kustomizations(Map.ofEntries(
 *                 Map.entry("srs-kustomization1", Map.ofEntries(
 *                     Map.entry("dependsOn", ),
 *                     Map.entry("path", "./test/path"),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600)
 *                 )),
 *                 Map.entry("srs-kustomization2", Map.ofEntries(
 *                     Map.entry("dependsOn", "srs-kustomization1"),
 *                     Map.entry("path", "./other/test/path"),
 *                     Map.entry("prune", false),
 *                     Map.entry("retryIntervalInSeconds", 600),
 *                     Map.entry("syncIntervalInSeconds", 600),
 *                     Map.entry("timeoutInSeconds", 600)
 *                 ))
 *             ))
 *             .namespace("srs-namespace")
 *             .resourceGroupName("rg1")
 *             .scope("cluster")
 *             .sourceKind("Bucket")
 *             .suspend(false)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kubernetesconfiguration:FluxConfiguration srs-fluxconfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{clusterRp}/{clusterResourceName}/{clusterName}/providers/Microsoft.KubernetesConfiguration/fluxConfigurations/{fluxConfigurationName}
 * ```
 */
public class FluxConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration,
) : KotlinCustomResource(javaResource, FluxConfigurationMapper) {
    /**
     * Parameters to reconcile to the AzureBlob source kind type.
     */
    public val azureBlob: Output<AzureBlobDefinitionResponse>?
        get() = javaResource.azureBlob().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    azureBlobDefinitionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Parameters to reconcile to the Bucket source kind type.
     */
    public val bucket: Output<BucketDefinitionResponse>?
        get() = javaResource.bucket().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    bucketDefinitionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Combined status of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed objects.
     */
    public val complianceState: Output<String>
        get() = javaResource.complianceState().applyValue({ args0 -> args0 })

    /**
     * Key-value pairs of protected configuration settings for the configuration
     */
    public val configurationProtectedSettings: Output<Map<String, String>>?
        get() = javaResource.configurationProtectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Error message returned to the user in the case of provisioning failure.
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * Parameters to reconcile to the GitRepository source kind type.
     */
    public val gitRepository: Output<GitRepositoryDefinitionResponse>?
        get() = javaResource.gitRepository().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gitRepositoryDefinitionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Array of kustomizations used to reconcile the artifact pulled by the source type on the cluster.
     */
    public val kustomizations: Output<Map<String, KustomizationDefinitionResponse>>?
        get() = javaResource.kustomizations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            kustomizationDefinitionResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The namespace to which this configuration is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
     */
    public val namespace: Output<String>?
        get() = javaResource.namespace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Status of the creation of the fluxConfiguration.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Maximum duration to wait for flux configuration reconciliation. E.g PT1H, PT5M, P1D
     */
    public val reconciliationWaitDuration: Output<String>?
        get() = javaResource.reconciliationWaitDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Public Key associated with this fluxConfiguration (either generated within the cluster or provided by the user).
     */
    public val repositoryPublicKey: Output<String>
        get() = javaResource.repositoryPublicKey().applyValue({ args0 -> args0 })

    /**
     * Scope at which the operator will be installed.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Source Kind to pull the configuration data from.
     */
    public val sourceKind: Output<String>?
        get() = javaResource.sourceKind().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Branch and/or SHA of the source commit synced with the cluster.
     */
    public val sourceSyncedCommitId: Output<String>
        get() = javaResource.sourceSyncedCommitId().applyValue({ args0 -> args0 })

    /**
     * Datetime the fluxConfiguration synced its source on the cluster.
     */
    public val sourceUpdatedAt: Output<String>
        get() = javaResource.sourceUpdatedAt().applyValue({ args0 -> args0 })

    /**
     * Datetime the fluxConfiguration synced its status on the cluster with Azure.
     */
    public val statusUpdatedAt: Output<String>
        get() = javaResource.statusUpdatedAt().applyValue({ args0 -> args0 })

    /**
     * Statuses of the Flux Kubernetes resources created by the fluxConfiguration or created by the managed objects provisioned by the fluxConfiguration.
     */
    public val statuses: Output<List<ObjectStatusDefinitionResponse>>
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    objectStatusDefinitionResponseToKotlin(args0)
                })
            })
        })

    /**
     * Whether this configuration should suspend its reconciliation of its kustomizations and sources.
     */
    public val `suspend`: Output<Boolean>?
        get() = javaResource.`suspend`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether flux configuration deployment should wait for cluster to reconcile the kustomizations.
     */
    public val waitForReconciliation: Output<Boolean>?
        get() = javaResource.waitForReconciliation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object FluxConfigurationMapper : ResourceMapper<FluxConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): FluxConfiguration = FluxConfiguration(
        javaResource as
            com.pulumi.azurenative.kubernetesconfiguration.FluxConfiguration,
    )
}

/**
 * @see [FluxConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FluxConfiguration].
 */
public suspend fun fluxConfiguration(
    name: String,
    block: suspend FluxConfigurationResourceBuilder.() -> Unit,
): FluxConfiguration {
    val builder = FluxConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FluxConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fluxConfiguration(name: String): FluxConfiguration {
    val builder = FluxConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
