@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.GetExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the kubernetes cluster.
 * @property clusterResourceName The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
 * @property clusterRp The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
 * @property extensionName Name of the Extension.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetExtensionPlainArgs(
    public val clusterName: String,
    public val clusterResourceName: String,
    public val clusterRp: String,
    public val extensionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.GetExtensionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.GetExtensionPlainArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.GetExtensionPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .clusterResourceName(clusterResourceName.let({ args0 -> args0 }))
            .clusterRp(clusterRp.let({ args0 -> args0 }))
            .extensionName(extensionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetExtensionPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var clusterResourceName: String? = null

    private var clusterRp: String? = null

    private var extensionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the kubernetes cluster.
     */
    @JvmName("rgtyuulxcncbxnrw")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The Kubernetes cluster resource name - i.e. managedClusters, connectedClusters, provisionedClusters.
     */
    @JvmName("ghhixiaslufrtdrd")
    public suspend fun clusterResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterResourceName = mapped
    }

    /**
     * @param value The Kubernetes cluster RP - i.e. Microsoft.ContainerService, Microsoft.Kubernetes, Microsoft.HybridContainerService.
     */
    @JvmName("tfsaxtverjkmlmfe")
    public suspend fun clusterRp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterRp = mapped
    }

    /**
     * @param value Name of the Extension.
     */
    @JvmName("bfxvbbeklcvoibkm")
    public suspend fun extensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.extensionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("exafydgfmvddunkm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExtensionPlainArgs = GetExtensionPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        clusterResourceName = clusterResourceName ?: throw PulumiNullFieldException("clusterResourceName"),
        clusterRp = clusterRp ?: throw PulumiNullFieldException("clusterRp"),
        extensionName = extensionName ?: throw PulumiNullFieldException("extensionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
