@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.inputs

import com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies that the scope of the extension is Cluster
 * @property releaseNamespace Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
 */
public data class ScopeClusterArgs(
    public val releaseNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeClusterArgs =
        com.pulumi.azurenative.kubernetesconfiguration.inputs.ScopeClusterArgs.builder()
            .releaseNamespace(releaseNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopeClusterArgs].
 */
@PulumiTagMarker
public class ScopeClusterArgsBuilder internal constructor() {
    private var releaseNamespace: Output<String>? = null

    /**
     * @param value Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
     */
    @JvmName("rmlqqreufvptqseq")
    public suspend fun releaseNamespace(`value`: Output<String>) {
        this.releaseNamespace = value
    }

    /**
     * @param value Namespace where the extension Release must be placed, for a Cluster scoped extension.  If this namespace does not exist, it will be created
     */
    @JvmName("fecyibosugbvwuoe")
    public suspend fun releaseNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseNamespace = mapped
    }

    internal fun build(): ScopeClusterArgs = ScopeClusterArgs(
        releaseNamespace = releaseNamespace,
    )
}
