@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The Extension object.
 * @property aksAssignedIdentity Identity of the Extension resource in an AKS cluster
 * @property autoUpgradeMinorVersion Flag to note if this extension participates in auto upgrade of minor version, or not.
 * @property configurationProtectedSettings Configuration settings that are sensitive, as name-value pairs for configuring this extension.
 * @property configurationSettings Configuration settings, as name-value pairs for configuring this extension.
 * @property currentVersion Currently installed version of the extension.
 * @property customLocationSettings Custom Location settings properties.
 * @property errorInfo Error information from the Agent - e.g. errors during installation.
 * @property extensionType Type of the Extension, of which this resource is an instance of.  It must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the Extension publisher.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity of the Extension resource
 * @property isSystemExtension Flag to note if this extension is a system extension
 * @property name The name of the resource
 * @property packageUri Uri of the Helm package
 * @property plan The plan information.
 * @property provisioningState Status of installation of this extension.
 * @property releaseTrain ReleaseTrain this extension participates in for auto-upgrade (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
 * @property scope Scope at which the extension is installed.
 * @property statuses Status from this extension.
 * @property systemData Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version User-specified version of the extension for this extension to 'pin'. To use 'version', autoUpgradeMinorVersion must be 'false'.
 */
public data class GetExtensionResult(
    public val aksAssignedIdentity: ExtensionResponseAksAssignedIdentity? = null,
    public val autoUpgradeMinorVersion: Boolean? = null,
    public val configurationProtectedSettings: Map<String, String>? = null,
    public val configurationSettings: Map<String, String>? = null,
    public val currentVersion: String,
    public val customLocationSettings: Map<String, String>,
    public val errorInfo: ErrorDetailResponse,
    public val extensionType: String? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val isSystemExtension: Boolean,
    public val name: String,
    public val packageUri: String,
    public val plan: PlanResponse? = null,
    public val provisioningState: String,
    public val releaseTrain: String? = null,
    public val scope: ScopeResponse? = null,
    public val statuses: List<ExtensionStatusResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.GetExtensionResult):
            GetExtensionResult = GetExtensionResult(
            aksAssignedIdentity = javaType.aksAssignedIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ExtensionResponseAksAssignedIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoUpgradeMinorVersion = javaType.autoUpgradeMinorVersion().map({ args0 -> args0 }).orElse(null),
            configurationProtectedSettings = javaType.configurationProtectedSettings().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            configurationSettings = javaType.configurationSettings().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            currentVersion = javaType.currentVersion(),
            customLocationSettings = javaType.customLocationSettings().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            errorInfo = javaType.errorInfo().let({ args0 ->
                com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
            }),
            extensionType = javaType.extensionType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isSystemExtension = javaType.isSystemExtension(),
            name = javaType.name(),
            packageUri = javaType.packageUri(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            releaseTrain = javaType.releaseTrain().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ScopeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statuses = javaType.statuses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ExtensionStatusResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
