@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The SourceControl Configuration object returned in Get & Put response.
 * @property complianceStatus Compliance Status of the Configuration
 * @property configurationProtectedSettings Name-value pairs of protected configuration settings for the configuration
 * @property enableHelmOperator Option to enable Helm Operator for this git configuration.
 * @property helmOperatorProperties Properties for Helm operator.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property operatorInstanceName Instance name of the operator - identifying the specific configuration.
 * @property operatorNamespace The namespace to which this operator is installed to. Maximum of 253 lower case alphanumeric characters, hyphen and period only.
 * @property operatorParams Any Parameters for the Operator instance in string format.
 * @property operatorScope Scope at which the operator will be installed.
 * @property operatorType Type of the operator
 * @property provisioningState The provisioning state of the resource provider.
 * @property repositoryPublicKey Public Key associated with this SourceControl configuration (either generated within the cluster or provided by the user).
 * @property repositoryUrl Url of the SourceControl Repository.
 * @property sshKnownHostsContents Base64-encoded known_hosts contents containing public SSH keys required to access private Git instances
 * @property systemData Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSourceControlConfigurationResult(
    public val complianceStatus: ComplianceStatusResponse,
    public val configurationProtectedSettings: Map<String, String>? = null,
    public val enableHelmOperator: Boolean? = null,
    public val helmOperatorProperties: HelmOperatorPropertiesResponse? = null,
    public val id: String,
    public val name: String,
    public val operatorInstanceName: String? = null,
    public val operatorNamespace: String? = null,
    public val operatorParams: String? = null,
    public val operatorScope: String? = null,
    public val operatorType: String? = null,
    public val provisioningState: String,
    public val repositoryPublicKey: String,
    public val repositoryUrl: String? = null,
    public val sshKnownHostsContents: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.GetSourceControlConfigurationResult):
            GetSourceControlConfigurationResult = GetSourceControlConfigurationResult(
            complianceStatus = javaType.complianceStatus().let({ args0 ->
                com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.ComplianceStatusResponse.Companion.toKotlin(args0)
            }),
            configurationProtectedSettings = javaType.configurationProtectedSettings().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            enableHelmOperator = javaType.enableHelmOperator().map({ args0 -> args0 }).orElse(null),
            helmOperatorProperties = javaType.helmOperatorProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.HelmOperatorPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            operatorInstanceName = javaType.operatorInstanceName().map({ args0 -> args0 }).orElse(null),
            operatorNamespace = javaType.operatorNamespace().map({ args0 -> args0 }).orElse(null),
            operatorParams = javaType.operatorParams().map({ args0 -> args0 }).orElse(null),
            operatorScope = javaType.operatorScope().map({ args0 -> args0 }).orElse(null),
            operatorType = javaType.operatorType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            repositoryPublicKey = javaType.repositoryPublicKey(),
            repositoryUrl = javaType.repositoryUrl().map({ args0 -> args0 }).orElse(null),
            sshKnownHostsContents = javaType.sshKnownHostsContents().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
