@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Parameters to reconcile to the GitRepository source kind type.
 * @property httpsCACert Base64-encoded HTTPS certificate authority contents used to access git private git repositories over HTTPS
 * @property httpsUser Plaintext HTTPS username used to access private git repositories over HTTPS
 * @property localAuthRef Name of a local secret on the Kubernetes cluster to use as the authentication secret rather than the managed or user-provided configuration secrets.
 * @property repositoryRef The source reference for the GitRepository object.
 * @property sshKnownHosts Base64-encoded known_hosts value containing public SSH keys required to access private git repositories over SSH
 * @property syncIntervalInSeconds The interval at which to re-reconcile the cluster git repository source with the remote.
 * @property timeoutInSeconds The maximum time to attempt to reconcile the cluster git repository source with the remote.
 * @property url The URL to sync for the flux configuration git repository.
 */
public data class GitRepositoryDefinitionResponse(
    public val httpsCACert: String? = null,
    public val httpsUser: String? = null,
    public val localAuthRef: String? = null,
    public val repositoryRef: RepositoryRefDefinitionResponse? = null,
    public val sshKnownHosts: String? = null,
    public val syncIntervalInSeconds: Double? = null,
    public val timeoutInSeconds: Double? = null,
    public val url: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.GitRepositoryDefinitionResponse):
            GitRepositoryDefinitionResponse = GitRepositoryDefinitionResponse(
            httpsCACert = javaType.httpsCACert().map({ args0 -> args0 }).orElse(null),
            httpsUser = javaType.httpsUser().map({ args0 -> args0 }).orElse(null),
            localAuthRef = javaType.localAuthRef().map({ args0 -> args0 }).orElse(null),
            repositoryRef = javaType.repositoryRef().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs.RepositoryRefDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sshKnownHosts = javaType.sshKnownHosts().map({ args0 -> args0 }).orElse(null),
            syncIntervalInSeconds = javaType.syncIntervalInSeconds().map({ args0 -> args0 }).orElse(null),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
