@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties for Helm operator.
 * @property chartValues Values override for the operator Helm chart.
 * @property chartVersion Version of the operator Helm chart.
 */
public data class HelmOperatorPropertiesResponse(
    public val chartValues: String? = null,
    public val chartVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.HelmOperatorPropertiesResponse):
            HelmOperatorPropertiesResponse = HelmOperatorPropertiesResponse(
            chartValues = javaType.chartValues().map({ args0 -> args0 }).orElse(null),
            chartVersion = javaType.chartVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
