@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Status condition of Kubernetes object
 * @property lastTransitionTime Last time this status condition has changed
 * @property message A more verbose description of the object status condition
 * @property reason Reason for the specified status condition type status
 * @property status Status of the Kubernetes object condition type
 * @property type Object status condition type for this object
 */
public data class ObjectStatusConditionDefinitionResponse(
    public val lastTransitionTime: String? = null,
    public val message: String? = null,
    public val reason: String? = null,
    public val status: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ObjectStatusConditionDefinitionResponse):
            ObjectStatusConditionDefinitionResponse = ObjectStatusConditionDefinitionResponse(
            lastTransitionTime = javaType.lastTransitionTime().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            reason = javaType.reason().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
