@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kubernetesconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies that the scope of the extension is Namespace
 * @property targetNamespace Namespace where the extension will be created for an Namespace scoped extension.  If this namespace does not exist, it will be created
 */
public data class ScopeNamespaceResponse(
    public val targetNamespace: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kubernetesconfiguration.outputs.ScopeNamespaceResponse):
            ScopeNamespaceResponse = ScopeNamespaceResponse(
            targetNamespace = javaType.targetNamespace().map({ args0 -> args0 }).orElse(null),
        )
    }
}
