@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.ClusterArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.ClusterNetworkAccessFlag
import com.pulumi.azurenative.kusto.kotlin.enums.EngineType
import com.pulumi.azurenative.kusto.kotlin.enums.PublicIPType
import com.pulumi.azurenative.kusto.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.kusto.kotlin.inputs.AcceptedAudiencesArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.AcceptedAudiencesArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.AzureSkuArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.AzureSkuArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.KeyVaultPropertiesArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.KeyVaultPropertiesArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.LanguageExtensionsListArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.LanguageExtensionsListArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.OptimizedAutoscaleArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.OptimizedAutoscaleArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.TrustedExternalTenantArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.TrustedExternalTenantArgsBuilder
import com.pulumi.azurenative.kusto.kotlin.inputs.VirtualNetworkConfigurationArgs
import com.pulumi.azurenative.kusto.kotlin.inputs.VirtualNetworkConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Class representing a Kusto cluster.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2022-07-07, 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoClustersCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.Kusto.Cluster("cluster", new()
 *     {
 *         AllowedIpRangeList = new[]
 *         {
 *             "0.0.0.0/0",
 *         },
 *         ClusterName = "kustoCluster",
 *         EnableAutoStop = true,
 *         EnableDoubleEncryption = false,
 *         EnablePurge = true,
 *         EnableStreamingIngest = true,
 *         Identity = new AzureNative.Kusto.Inputs.IdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         LanguageExtensions = new AzureNative.Kusto.Inputs.LanguageExtensionsListArgs
 *         {
 *             Value = new[]
 *             {
 *                 new AzureNative.Kusto.Inputs.LanguageExtensionArgs
 *                 {
 *                     LanguageExtensionImageName = "Python3_10_8",
 *                     LanguageExtensionName = "PYTHON",
 *                 },
 *                 new AzureNative.Kusto.Inputs.LanguageExtensionArgs
 *                 {
 *                     LanguageExtensionImageName = "R",
 *                     LanguageExtensionName = "R",
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         PublicIPType = "DualStack",
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "kustorptest",
 *         Sku = new AzureNative.Kusto.Inputs.AzureSkuArgs
 *         {
 *             Capacity = 2,
 *             Name = "Standard_L16as_v3",
 *             Tier = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCluster(ctx, "cluster", &kusto.ClusterArgs{
 * 			AllowedIpRangeList: pulumi.StringArray{
 * 				pulumi.String("0.0.0.0/0"),
 * 			},
 * 			ClusterName:            pulumi.String("kustoCluster"),
 * 			EnableAutoStop:         pulumi.Bool(true),
 * 			EnableDoubleEncryption: pulumi.Bool(false),
 * 			EnablePurge:            pulumi.Bool(true),
 * 			EnableStreamingIngest:  pulumi.Bool(true),
 * 			Identity: &kusto.IdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			LanguageExtensions: kusto.LanguageExtensionsListResponse{
 * 				Value: kusto.LanguageExtensionArray{
 * 					&kusto.LanguageExtensionArgs{
 * 						LanguageExtensionImageName: pulumi.String("Python3_10_8"),
 * 						LanguageExtensionName:      pulumi.String("PYTHON"),
 * 					},
 * 					&kusto.LanguageExtensionArgs{
 * 						LanguageExtensionImageName: pulumi.String("R"),
 * 						LanguageExtensionName:      pulumi.String("R"),
 * 					},
 * 				},
 * 			},
 * 			Location:            pulumi.String("westus"),
 * 			PublicIPType:        pulumi.String("DualStack"),
 * 			PublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:   pulumi.String("kustorptest"),
 * 			Sku: &kusto.AzureSkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 				Name:     pulumi.String("Standard_L16as_v3"),
 * 				Tier:     pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.Cluster;
 * import com.pulumi.azurenative.kusto.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .allowedIpRangeList("0.0.0.0/0")
 *             .clusterName("kustoCluster")
 *             .enableAutoStop(true)
 *             .enableDoubleEncryption(false)
 *             .enablePurge(true)
 *             .enableStreamingIngest(true)
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .languageExtensions(Map.of("value",
 *                 Map.ofEntries(
 *                     Map.entry("languageExtensionImageName", "Python3_10_8"),
 *                     Map.entry("languageExtensionName", "PYTHON")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("languageExtensionImageName", "R"),
 *                     Map.entry("languageExtensionName", "R")
 *                 )))
 *             .location("westus")
 *             .publicIPType("DualStack")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("kustorptest")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 2),
 *                 Map.entry("name", "Standard_L16as_v3"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:Cluster kustoCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}
 * ```
 * @property acceptedAudiences The cluster's accepted audiences.
 * @property allowedFqdnList List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
 * @property allowedIpRangeList The list of ips in the format of CIDR allowed to connect to the cluster.
 * @property clusterName The name of the Kusto cluster.
 * @property enableAutoStop A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many days).
 * @property enableDiskEncryption A boolean value that indicates if the cluster's disks are encrypted.
 * @property enableDoubleEncryption A boolean value that indicates if double encryption is enabled.
 * @property enablePurge A boolean value that indicates if the purge operations are enabled.
 * @property enableStreamingIngest A boolean value that indicates if the streaming ingest is enabled.
 * @property engineType The engine type
 * @property identity The identity of the cluster, if configured.
 * @property keyVaultProperties KeyVault properties for the cluster encryption.
 * @property languageExtensions List of the cluster's language extensions.
 * @property location The geo-location where the resource lives
 * @property optimizedAutoscale Optimized auto scale definition.
 * @property publicIPType Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
 * @property publicNetworkAccess Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property restrictOutboundNetworkAccess Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property sku The SKU of the cluster.
 * @property tags Resource tags.
 * @property trustedExternalTenants The cluster's external tenants.
 * @property virtualClusterGraduationProperties Virtual Cluster graduation properties
 * @property virtualNetworkConfiguration Virtual network definition.
 * @property zones The availability zones of the cluster.
 */
public data class ClusterArgs(
    public val acceptedAudiences: Output<List<AcceptedAudiencesArgs>>? = null,
    public val allowedFqdnList: Output<List<String>>? = null,
    public val allowedIpRangeList: Output<List<String>>? = null,
    public val clusterName: Output<String>? = null,
    public val enableAutoStop: Output<Boolean>? = null,
    public val enableDiskEncryption: Output<Boolean>? = null,
    public val enableDoubleEncryption: Output<Boolean>? = null,
    public val enablePurge: Output<Boolean>? = null,
    public val enableStreamingIngest: Output<Boolean>? = null,
    public val engineType: Output<Either<String, EngineType>>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
    public val languageExtensions: Output<LanguageExtensionsListArgs>? = null,
    public val location: Output<String>? = null,
    public val optimizedAutoscale: Output<OptimizedAutoscaleArgs>? = null,
    public val publicIPType: Output<Either<String, PublicIPType>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restrictOutboundNetworkAccess: Output<Either<String, ClusterNetworkAccessFlag>>? =
        null,
    public val sku: Output<AzureSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trustedExternalTenants: Output<List<TrustedExternalTenantArgs>>? = null,
    public val virtualClusterGraduationProperties: Output<String>? = null,
    public val virtualNetworkConfiguration: Output<VirtualNetworkConfigurationArgs>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.ClusterArgs =
        com.pulumi.azurenative.kusto.ClusterArgs.builder()
            .acceptedAudiences(
                acceptedAudiences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .allowedFqdnList(allowedFqdnList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedIpRangeList(allowedIpRangeList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .enableAutoStop(enableAutoStop?.applyValue({ args0 -> args0 }))
            .enableDiskEncryption(enableDiskEncryption?.applyValue({ args0 -> args0 }))
            .enableDoubleEncryption(enableDoubleEncryption?.applyValue({ args0 -> args0 }))
            .enablePurge(enablePurge?.applyValue({ args0 -> args0 }))
            .enableStreamingIngest(enableStreamingIngest?.applyValue({ args0 -> args0 }))
            .engineType(
                engineType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .languageExtensions(
                languageExtensions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .optimizedAutoscale(
                optimizedAutoscale?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicIPType(
                publicIPType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restrictOutboundNetworkAccess(
                restrictOutboundNetworkAccess?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trustedExternalTenants(
                trustedExternalTenants?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualClusterGraduationProperties(
                virtualClusterGraduationProperties?.applyValue({ args0 ->
                    args0
                }),
            )
            .virtualNetworkConfiguration(
                virtualNetworkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var acceptedAudiences: Output<List<AcceptedAudiencesArgs>>? = null

    private var allowedFqdnList: Output<List<String>>? = null

    private var allowedIpRangeList: Output<List<String>>? = null

    private var clusterName: Output<String>? = null

    private var enableAutoStop: Output<Boolean>? = null

    private var enableDiskEncryption: Output<Boolean>? = null

    private var enableDoubleEncryption: Output<Boolean>? = null

    private var enablePurge: Output<Boolean>? = null

    private var enableStreamingIngest: Output<Boolean>? = null

    private var engineType: Output<Either<String, EngineType>>? = null

    private var identity: Output<IdentityArgs>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    private var languageExtensions: Output<LanguageExtensionsListArgs>? = null

    private var location: Output<String>? = null

    private var optimizedAutoscale: Output<OptimizedAutoscaleArgs>? = null

    private var publicIPType: Output<Either<String, PublicIPType>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restrictOutboundNetworkAccess: Output<Either<String, ClusterNetworkAccessFlag>>? =
        null

    private var sku: Output<AzureSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trustedExternalTenants: Output<List<TrustedExternalTenantArgs>>? = null

    private var virtualClusterGraduationProperties: Output<String>? = null

    private var virtualNetworkConfiguration: Output<VirtualNetworkConfigurationArgs>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The cluster's accepted audiences.
     */
    @JvmName("uirbbhjykfhgcrdt")
    public suspend fun acceptedAudiences(`value`: Output<List<AcceptedAudiencesArgs>>) {
        this.acceptedAudiences = value
    }

    @JvmName("ofjdlqvlohhrvthl")
    public suspend fun acceptedAudiences(vararg values: Output<AcceptedAudiencesArgs>) {
        this.acceptedAudiences = Output.all(values.asList())
    }

    /**
     * @param values The cluster's accepted audiences.
     */
    @JvmName("oaltlsjjtgvvwwfr")
    public suspend fun acceptedAudiences(values: List<Output<AcceptedAudiencesArgs>>) {
        this.acceptedAudiences = Output.all(values)
    }

    /**
     * @param value List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
     */
    @JvmName("yeibpmmwtgihysgl")
    public suspend fun allowedFqdnList(`value`: Output<List<String>>) {
        this.allowedFqdnList = value
    }

    @JvmName("ffylntyhjanksklc")
    public suspend fun allowedFqdnList(vararg values: Output<String>) {
        this.allowedFqdnList = Output.all(values.asList())
    }

    /**
     * @param values List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
     */
    @JvmName("aqqcalkmthfyicwm")
    public suspend fun allowedFqdnList(values: List<Output<String>>) {
        this.allowedFqdnList = Output.all(values)
    }

    /**
     * @param value The list of ips in the format of CIDR allowed to connect to the cluster.
     */
    @JvmName("cldlwtlacvwpwbcu")
    public suspend fun allowedIpRangeList(`value`: Output<List<String>>) {
        this.allowedIpRangeList = value
    }

    @JvmName("jhawuxklchlgruxi")
    public suspend fun allowedIpRangeList(vararg values: Output<String>) {
        this.allowedIpRangeList = Output.all(values.asList())
    }

    /**
     * @param values The list of ips in the format of CIDR allowed to connect to the cluster.
     */
    @JvmName("ktfrwotqklitholn")
    public suspend fun allowedIpRangeList(values: List<Output<String>>) {
        this.allowedIpRangeList = Output.all(values)
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("gryeymmkgnjickoe")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many days).
     */
    @JvmName("dqiqxiaoaftoneby")
    public suspend fun enableAutoStop(`value`: Output<Boolean>) {
        this.enableAutoStop = value
    }

    /**
     * @param value A boolean value that indicates if the cluster's disks are encrypted.
     */
    @JvmName("prncfmpaatewnxfm")
    public suspend fun enableDiskEncryption(`value`: Output<Boolean>) {
        this.enableDiskEncryption = value
    }

    /**
     * @param value A boolean value that indicates if double encryption is enabled.
     */
    @JvmName("brakhugicigqtmed")
    public suspend fun enableDoubleEncryption(`value`: Output<Boolean>) {
        this.enableDoubleEncryption = value
    }

    /**
     * @param value A boolean value that indicates if the purge operations are enabled.
     */
    @JvmName("jsmeasiyrrqtiyho")
    public suspend fun enablePurge(`value`: Output<Boolean>) {
        this.enablePurge = value
    }

    /**
     * @param value A boolean value that indicates if the streaming ingest is enabled.
     */
    @JvmName("fvmaggvahcbruyqd")
    public suspend fun enableStreamingIngest(`value`: Output<Boolean>) {
        this.enableStreamingIngest = value
    }

    /**
     * @param value The engine type
     */
    @JvmName("wbjfchwonpqrhpoo")
    public suspend fun engineType(`value`: Output<Either<String, EngineType>>) {
        this.engineType = value
    }

    /**
     * @param value The identity of the cluster, if configured.
     */
    @JvmName("jcgywvbwclhemivi")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value KeyVault properties for the cluster encryption.
     */
    @JvmName("quysirjiqcxfhjtg")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value List of the cluster's language extensions.
     */
    @JvmName("whmvyjygyytwadvi")
    public suspend fun languageExtensions(`value`: Output<LanguageExtensionsListArgs>) {
        this.languageExtensions = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("haiecixtuvcaalbo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Optimized auto scale definition.
     */
    @JvmName("wkuyctffalrmaqdf")
    public suspend fun optimizedAutoscale(`value`: Output<OptimizedAutoscaleArgs>) {
        this.optimizedAutoscale = value
    }

    /**
     * @param value Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
     */
    @JvmName("fyyfjbdudlvlhxjc")
    public suspend fun publicIPType(`value`: Output<Either<String, PublicIPType>>) {
        this.publicIPType = value
    }

    /**
     * @param value Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed
     */
    @JvmName("wsedmbytwfogcnls")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("fovutmlncifklutv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("ceukaywxeguoamgl")
    public suspend
    fun restrictOutboundNetworkAccess(`value`: Output<Either<String, ClusterNetworkAccessFlag>>) {
        this.restrictOutboundNetworkAccess = value
    }

    /**
     * @param value The SKU of the cluster.
     */
    @JvmName("mbmsltqghmwanbyh")
    public suspend fun sku(`value`: Output<AzureSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cyxbstarldcngbig")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The cluster's external tenants.
     */
    @JvmName("nolgqtxymoxmrtiy")
    public suspend fun trustedExternalTenants(`value`: Output<List<TrustedExternalTenantArgs>>) {
        this.trustedExternalTenants = value
    }

    @JvmName("betgaaiocdwudhqb")
    public suspend fun trustedExternalTenants(vararg values: Output<TrustedExternalTenantArgs>) {
        this.trustedExternalTenants = Output.all(values.asList())
    }

    /**
     * @param values The cluster's external tenants.
     */
    @JvmName("igbxrajmvscxpjaa")
    public suspend fun trustedExternalTenants(values: List<Output<TrustedExternalTenantArgs>>) {
        this.trustedExternalTenants = Output.all(values)
    }

    /**
     * @param value Virtual Cluster graduation properties
     */
    @JvmName("pxwfkaapxumigcru")
    public suspend fun virtualClusterGraduationProperties(`value`: Output<String>) {
        this.virtualClusterGraduationProperties = value
    }

    /**
     * @param value Virtual network definition.
     */
    @JvmName("eouvdbawnsynmeip")
    public suspend fun virtualNetworkConfiguration(`value`: Output<VirtualNetworkConfigurationArgs>) {
        this.virtualNetworkConfiguration = value
    }

    /**
     * @param value The availability zones of the cluster.
     */
    @JvmName("tpqgnumptdrijjsd")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("qmymbvlixitcevlx")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The availability zones of the cluster.
     */
    @JvmName("xcdarkeoxirykoqw")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The cluster's accepted audiences.
     */
    @JvmName("fktgdsuttiyclune")
    public suspend fun acceptedAudiences(`value`: List<AcceptedAudiencesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptedAudiences = mapped
    }

    /**
     * @param argument The cluster's accepted audiences.
     */
    @JvmName("fimjlqoxvudjudjs")
    public suspend
    fun acceptedAudiences(argument: List<suspend AcceptedAudiencesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AcceptedAudiencesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.acceptedAudiences = mapped
    }

    /**
     * @param argument The cluster's accepted audiences.
     */
    @JvmName("wuqoypdocctbtehk")
    public suspend fun acceptedAudiences(
        vararg
        argument: suspend AcceptedAudiencesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AcceptedAudiencesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.acceptedAudiences = mapped
    }

    /**
     * @param argument The cluster's accepted audiences.
     */
    @JvmName("flwlobldlgqnkjfp")
    public suspend fun acceptedAudiences(argument: suspend AcceptedAudiencesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AcceptedAudiencesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.acceptedAudiences = mapped
    }

    /**
     * @param values The cluster's accepted audiences.
     */
    @JvmName("vvwyuqjondncfmes")
    public suspend fun acceptedAudiences(vararg values: AcceptedAudiencesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceptedAudiences = mapped
    }

    /**
     * @param value List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
     */
    @JvmName("eprmjbbyqrhcldxq")
    public suspend fun allowedFqdnList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedFqdnList = mapped
    }

    /**
     * @param values List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
     */
    @JvmName("clltimqqqwgenald")
    public suspend fun allowedFqdnList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedFqdnList = mapped
    }

    /**
     * @param value The list of ips in the format of CIDR allowed to connect to the cluster.
     */
    @JvmName("olhhvuwjbjowdjuj")
    public suspend fun allowedIpRangeList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedIpRangeList = mapped
    }

    /**
     * @param values The list of ips in the format of CIDR allowed to connect to the cluster.
     */
    @JvmName("jhndlprlslmejpmk")
    public suspend fun allowedIpRangeList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedIpRangeList = mapped
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("phokcctqfhldsjnw")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value A boolean value that indicates if the cluster could be automatically stopped (due to lack of data or no activity for many days).
     */
    @JvmName("inpckqfnvrwefqyj")
    public suspend fun enableAutoStop(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutoStop = mapped
    }

    /**
     * @param value A boolean value that indicates if the cluster's disks are encrypted.
     */
    @JvmName("bemxoayjodjritks")
    public suspend fun enableDiskEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDiskEncryption = mapped
    }

    /**
     * @param value A boolean value that indicates if double encryption is enabled.
     */
    @JvmName("dlefmmahgfaeqtpb")
    public suspend fun enableDoubleEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDoubleEncryption = mapped
    }

    /**
     * @param value A boolean value that indicates if the purge operations are enabled.
     */
    @JvmName("hklatemanaxqplbn")
    public suspend fun enablePurge(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePurge = mapped
    }

    /**
     * @param value A boolean value that indicates if the streaming ingest is enabled.
     */
    @JvmName("nqnbeqmwjvjtfelg")
    public suspend fun enableStreamingIngest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStreamingIngest = mapped
    }

    /**
     * @param value The engine type
     */
    @JvmName("ypblpeppuhgunquo")
    public suspend fun engineType(`value`: Either<String, EngineType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value The engine type
     */
    @JvmName("jdsgmwperjraiegg")
    public fun engineType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EngineType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value The engine type
     */
    @JvmName("bgkrtoqaiusbyuma")
    public fun engineType(`value`: EngineType) {
        val toBeMapped = Either.ofRight<String, EngineType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.engineType = mapped
    }

    /**
     * @param value The identity of the cluster, if configured.
     */
    @JvmName("ioxgshktmfkrlmae")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the cluster, if configured.
     */
    @JvmName("btqldldxnejffabi")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value KeyVault properties for the cluster encryption.
     */
    @JvmName("symucvpuvvsoaxkp")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument KeyVault properties for the cluster encryption.
     */
    @JvmName("agurowdyfabrplvf")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value List of the cluster's language extensions.
     */
    @JvmName("mddawoakbjprlynu")
    public suspend fun languageExtensions(`value`: LanguageExtensionsListArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageExtensions = mapped
    }

    /**
     * @param argument List of the cluster's language extensions.
     */
    @JvmName("gdyxlcyplsqrwsui")
    public suspend
    fun languageExtensions(argument: suspend LanguageExtensionsListArgsBuilder.() -> Unit) {
        val toBeMapped = LanguageExtensionsListArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.languageExtensions = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yihacmknqrhvwkeo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Optimized auto scale definition.
     */
    @JvmName("cpkwtwtcnjqyrlaw")
    public suspend fun optimizedAutoscale(`value`: OptimizedAutoscaleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizedAutoscale = mapped
    }

    /**
     * @param argument Optimized auto scale definition.
     */
    @JvmName("ltiybnwjhgebbtyc")
    public suspend
    fun optimizedAutoscale(argument: suspend OptimizedAutoscaleArgsBuilder.() -> Unit) {
        val toBeMapped = OptimizedAutoscaleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.optimizedAutoscale = mapped
    }

    /**
     * @param value Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
     */
    @JvmName("pgvvafpvvxcoxgto")
    public suspend fun publicIPType(`value`: Either<String, PublicIPType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPType = mapped
    }

    /**
     * @param value Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
     */
    @JvmName("tefvviehgsxpyhwh")
    public fun publicIPType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicIPType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPType = mapped
    }

    /**
     * @param value Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
     */
    @JvmName("fifilsdroaulpfuk")
    public fun publicIPType(`value`: PublicIPType) {
        val toBeMapped = Either.ofRight<String, PublicIPType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPType = mapped
    }

    /**
     * @param value Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed
     */
    @JvmName("bmpbxkpvxsxwnyti")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed
     */
    @JvmName("kmrabqwjxxnkyvhp")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed
     */
    @JvmName("kpyeteekkuicrvim")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("yjlrnfjqjajugewi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("brgdaxuglqeoeefd")
    public suspend
    fun restrictOutboundNetworkAccess(`value`: Either<String, ClusterNetworkAccessFlag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("kcsnwfbwbhepfgfw")
    public fun restrictOutboundNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value Whether or not to restrict outbound network access.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("jsamcadmymkidyem")
    public fun restrictOutboundNetworkAccess(`value`: ClusterNetworkAccessFlag) {
        val toBeMapped = Either.ofRight<String, ClusterNetworkAccessFlag>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value The SKU of the cluster.
     */
    @JvmName("qbpradqjymqvwcds")
    public suspend fun sku(`value`: AzureSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the cluster.
     */
    @JvmName("wvfmprjrcmrlnwud")
    public suspend fun sku(argument: suspend AzureSkuArgsBuilder.() -> Unit) {
        val toBeMapped = AzureSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cchmtvyvihxqxsrc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kybvtkxupttriwpb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The cluster's external tenants.
     */
    @JvmName("fdiwnftqmijjvwnt")
    public suspend fun trustedExternalTenants(`value`: List<TrustedExternalTenantArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedExternalTenants = mapped
    }

    /**
     * @param argument The cluster's external tenants.
     */
    @JvmName("yduaktdvwiusjmvb")
    public suspend
    fun trustedExternalTenants(argument: List<suspend TrustedExternalTenantArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrustedExternalTenantArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedExternalTenants = mapped
    }

    /**
     * @param argument The cluster's external tenants.
     */
    @JvmName("ntmsxisibhdevnfo")
    public suspend fun trustedExternalTenants(
        vararg
        argument: suspend TrustedExternalTenantArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrustedExternalTenantArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trustedExternalTenants = mapped
    }

    /**
     * @param argument The cluster's external tenants.
     */
    @JvmName("mxxcqkkjwkfbscqs")
    public suspend
    fun trustedExternalTenants(argument: suspend TrustedExternalTenantArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrustedExternalTenantArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trustedExternalTenants = mapped
    }

    /**
     * @param values The cluster's external tenants.
     */
    @JvmName("djnsdqdnwgoyjcgr")
    public suspend fun trustedExternalTenants(vararg values: TrustedExternalTenantArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedExternalTenants = mapped
    }

    /**
     * @param value Virtual Cluster graduation properties
     */
    @JvmName("ehkrcrilrjmfkfar")
    public suspend fun virtualClusterGraduationProperties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualClusterGraduationProperties = mapped
    }

    /**
     * @param value Virtual network definition.
     */
    @JvmName("wnburhnxapqggpsq")
    public suspend fun virtualNetworkConfiguration(`value`: VirtualNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkConfiguration = mapped
    }

    /**
     * @param argument Virtual network definition.
     */
    @JvmName("fdfweyvnpeyysnea")
    public suspend
    fun virtualNetworkConfiguration(argument: suspend VirtualNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetworkConfiguration = mapped
    }

    /**
     * @param value The availability zones of the cluster.
     */
    @JvmName("mrsmajjaneestqij")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The availability zones of the cluster.
     */
    @JvmName("inomixgiuaxvrblp")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        acceptedAudiences = acceptedAudiences,
        allowedFqdnList = allowedFqdnList,
        allowedIpRangeList = allowedIpRangeList,
        clusterName = clusterName,
        enableAutoStop = enableAutoStop,
        enableDiskEncryption = enableDiskEncryption,
        enableDoubleEncryption = enableDoubleEncryption,
        enablePurge = enablePurge,
        enableStreamingIngest = enableStreamingIngest,
        engineType = engineType,
        identity = identity,
        keyVaultProperties = keyVaultProperties,
        languageExtensions = languageExtensions,
        location = location,
        optimizedAutoscale = optimizedAutoscale,
        publicIPType = publicIPType,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        restrictOutboundNetworkAccess = restrictOutboundNetworkAccess,
        sku = sku,
        tags = tags,
        trustedExternalTenants = trustedExternalTenants,
        virtualClusterGraduationProperties = virtualClusterGraduationProperties,
        virtualNetworkConfiguration = virtualNetworkConfiguration,
        zones = zones,
    )
}
