@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CosmosDbDataConnection].
 */
@PulumiTagMarker
public class CosmosDbDataConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CosmosDbDataConnectionArgs = CosmosDbDataConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CosmosDbDataConnectionArgsBuilder.() -> Unit) {
        val builder = CosmosDbDataConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CosmosDbDataConnection {
        val builtJavaResource =
            com.pulumi.azurenative.kusto.CosmosDbDataConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CosmosDbDataConnection(builtJavaResource)
    }
}

/**
 * Class representing a CosmosDb data connection.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### KustoDataConnectionsCosmosDbCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cosmosDbDataConnection = new AzureNative.Kusto.CosmosDbDataConnection("cosmosDbDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         CosmosDbAccountResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.DocumentDb/databaseAccounts/cosmosDbAccountTest1",
 *         CosmosDbContainer = "cosmosDbContainerTest",
 *         CosmosDbDatabase = "cosmosDbDatabaseTest",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase1",
 *         Kind = "CosmosDb",
 *         Location = "westus",
 *         ManagedIdentityResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1",
 *         MappingRuleName = "TestMapping",
 *         ResourceGroupName = "kustorptest",
 *         RetrievalStartDate = "2022-07-29T12:00:00.6554616Z",
 *         TableName = "TestTable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCosmosDbDataConnection(ctx, "cosmosDbDataConnection", &kusto.CosmosDbDataConnectionArgs{
 * 			ClusterName:               pulumi.String("kustoCluster"),
 * 			CosmosDbAccountResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.DocumentDb/databaseAccounts/cosmosDbAccountTest1"),
 * 			CosmosDbContainer:         pulumi.String("cosmosDbContainerTest"),
 * 			CosmosDbDatabase:          pulumi.String("cosmosDbDatabaseTest"),
 * 			DataConnectionName:        pulumi.String("dataConnectionTest"),
 * 			DatabaseName:              pulumi.String("KustoDatabase1"),
 * 			Kind:                      pulumi.String("CosmosDb"),
 * 			Location:                  pulumi.String("westus"),
 * 			ManagedIdentityResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1"),
 * 			MappingRuleName:           pulumi.String("TestMapping"),
 * 			ResourceGroupName:         pulumi.String("kustorptest"),
 * 			RetrievalStartDate:        pulumi.String("2022-07-29T12:00:00.6554616Z"),
 * 			TableName:                 pulumi.String("TestTable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnection;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cosmosDbDataConnection = new CosmosDbDataConnection("cosmosDbDataConnection", CosmosDbDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .cosmosDbAccountResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.DocumentDb/databaseAccounts/cosmosDbAccountTest1")
 *             .cosmosDbContainer("cosmosDbContainerTest")
 *             .cosmosDbDatabase("cosmosDbDatabaseTest")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase1")
 *             .kind("CosmosDb")
 *             .location("westus")
 *             .managedIdentityResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1")
 *             .mappingRuleName("TestMapping")
 *             .resourceGroupName("kustorptest")
 *             .retrievalStartDate("2022-07-29T12:00:00.6554616Z")
 *             .tableName("TestTable")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cosmosDbDataConnection = new AzureNative.Kusto.CosmosDbDataConnection("cosmosDbDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCosmosDbDataConnection(ctx, "cosmosDbDataConnection", &kusto.CosmosDbDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnection;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cosmosDbDataConnection = new CosmosDbDataConnection("cosmosDbDataConnection", CosmosDbDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsEventGridCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cosmosDbDataConnection = new AzureNative.Kusto.CosmosDbDataConnection("cosmosDbDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewCosmosDbDataConnection(ctx, "cosmosDbDataConnection", &kusto.CosmosDbDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnection;
 * import com.pulumi.azurenative.kusto.CosmosDbDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cosmosDbDataConnection = new CosmosDbDataConnection("cosmosDbDataConnection", CosmosDbDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:CosmosDbDataConnection kustoCluster/KustoDatabase8/dataConnectionTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 */
public class CosmosDbDataConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.CosmosDbDataConnection,
) : KotlinCustomResource(javaResource, CosmosDbDataConnectionMapper) {
    /**
     * The resource ID of the Cosmos DB account used to create the data connection.
     */
    public val cosmosDbAccountResourceId: Output<String>
        get() = javaResource.cosmosDbAccountResourceId().applyValue({ args0 -> args0 })

    /**
     * The name of an existing container in the Cosmos DB database.
     */
    public val cosmosDbContainer: Output<String>
        get() = javaResource.cosmosDbContainer().applyValue({ args0 -> args0 })

    /**
     * The name of an existing database in the Cosmos DB account.
     */
    public val cosmosDbDatabase: Output<String>
        get() = javaResource.cosmosDbDatabase().applyValue({ args0 -> args0 })

    /**
     * Kind of the endpoint for the data connection
     * Expected value is 'CosmosDb'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The object ID of the managed identity resource.
     */
    public val managedIdentityObjectId: Output<String>
        get() = javaResource.managedIdentityObjectId().applyValue({ args0 -> args0 })

    /**
     * The resource ID of a managed system or user-assigned identity. The identity is used to authenticate with Cosmos DB.
     */
    public val managedIdentityResourceId: Output<String>
        get() = javaResource.managedIdentityResourceId().applyValue({ args0 -> args0 })

    /**
     * The name of an existing mapping rule to use when ingesting the retrieved data.
     */
    public val mappingRuleName: Output<String>?
        get() = javaResource.mappingRuleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Optional. If defined, the data connection retrieves Cosmos DB documents created or updated after the specified retrieval start date.
     */
    public val retrievalStartDate: Output<String>?
        get() = javaResource.retrievalStartDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The case-sensitive name of the existing target table in your cluster. Retrieved data is ingested into this table.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CosmosDbDataConnectionMapper : ResourceMapper<CosmosDbDataConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.CosmosDbDataConnection::class == javaResource::class

    override fun map(javaResource: Resource): CosmosDbDataConnection =
        CosmosDbDataConnection(javaResource as com.pulumi.azurenative.kusto.CosmosDbDataConnection)
}

/**
 * @see [CosmosDbDataConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CosmosDbDataConnection].
 */
public suspend fun cosmosDbDataConnection(
    name: String,
    block: suspend CosmosDbDataConnectionResourceBuilder.() -> Unit,
): CosmosDbDataConnection {
    val builder = CosmosDbDataConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CosmosDbDataConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cosmosDbDataConnection(name: String): CosmosDbDataConnection {
    val builder = CosmosDbDataConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
