@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.EventHubDataConnectionArgs.builder
import com.pulumi.azurenative.kusto.kotlin.enums.Compression
import com.pulumi.azurenative.kusto.kotlin.enums.DatabaseRouting
import com.pulumi.azurenative.kusto.kotlin.enums.EventHubDataFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class representing an event hub data connection.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### KustoDataConnectionsCosmosDbCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubDataConnection = new AzureNative.Kusto.EventHubDataConnection("eventHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase1",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventHubDataConnection(ctx, "eventHubDataConnection", &kusto.EventHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase1"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventHubDataConnection;
 * import com.pulumi.azurenative.kusto.EventHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubDataConnection = new EventHubDataConnection("eventHubDataConnection", EventHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase1")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubDataConnection = new AzureNative.Kusto.EventHubDataConnection("eventHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         ConsumerGroup = "testConsumerGroup1",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         EventHubResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1",
 *         Kind = "EventHub",
 *         Location = "westus",
 *         ManagedIdentityResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventHubDataConnection(ctx, "eventHubDataConnection", &kusto.EventHubDataConnectionArgs{
 * 			ClusterName:               pulumi.String("kustoCluster"),
 * 			ConsumerGroup:             pulumi.String("testConsumerGroup1"),
 * 			DataConnectionName:        pulumi.String("dataConnectionTest"),
 * 			DatabaseName:              pulumi.String("KustoDatabase8"),
 * 			EventHubResourceId:        pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1"),
 * 			Kind:                      pulumi.String("EventHub"),
 * 			Location:                  pulumi.String("westus"),
 * 			ManagedIdentityResourceId: pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1"),
 * 			ResourceGroupName:         pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventHubDataConnection;
 * import com.pulumi.azurenative.kusto.EventHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubDataConnection = new EventHubDataConnection("eventHubDataConnection", EventHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .consumerGroup("testConsumerGroup1")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .eventHubResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.EventHub/namespaces/eventhubTestns1/eventhubs/eventhubTest1")
 *             .kind("EventHub")
 *             .location("westus")
 *             .managedIdentityResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.ManagedIdentity/userAssignedIdentities/managedidentityTest1")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsEventGridCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventHubDataConnection = new AzureNative.Kusto.EventHubDataConnection("eventHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewEventHubDataConnection(ctx, "eventHubDataConnection", &kusto.EventHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.EventHubDataConnection;
 * import com.pulumi.azurenative.kusto.EventHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventHubDataConnection = new EventHubDataConnection("eventHubDataConnection", EventHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:EventHubDataConnection kustoCluster/KustoDatabase8/dataConnectionTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property compression The event hub messages compression type
 * @property consumerGroup The event hub consumer group.
 * @property dataConnectionName The name of the data connection.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property databaseRouting Indication for database routing information from the data connection, by default only database routing information is allowed
 * @property eventHubResourceId The resource ID of the event hub to be used to create a data connection.
 * @property eventSystemProperties System properties of the event hub
 * @property kind Kind of the endpoint for the data connection
 * Expected value is 'EventHub'.
 * @property location Resource location.
 * @property managedIdentityResourceId The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property retrievalStartDate When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 */
public data class EventHubDataConnectionArgs(
    public val clusterName: Output<String>? = null,
    public val compression: Output<Either<String, Compression>>? = null,
    public val consumerGroup: Output<String>? = null,
    public val dataConnectionName: Output<String>? = null,
    public val dataFormat: Output<Either<String, EventHubDataFormat>>? = null,
    public val databaseName: Output<String>? = null,
    public val databaseRouting: Output<Either<String, DatabaseRouting>>? = null,
    public val eventHubResourceId: Output<String>? = null,
    public val eventSystemProperties: Output<List<String>>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedIdentityResourceId: Output<String>? = null,
    public val mappingRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retrievalStartDate: Output<String>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.EventHubDataConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.EventHubDataConnectionArgs =
        com.pulumi.azurenative.kusto.EventHubDataConnectionArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .compression(
                compression?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .consumerGroup(consumerGroup?.applyValue({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName?.applyValue({ args0 -> args0 }))
            .dataFormat(
                dataFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .databaseRouting(
                databaseRouting?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eventHubResourceId(eventHubResourceId?.applyValue({ args0 -> args0 }))
            .eventSystemProperties(eventSystemProperties?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedIdentityResourceId(managedIdentityResourceId?.applyValue({ args0 -> args0 }))
            .mappingRuleName(mappingRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retrievalStartDate(retrievalStartDate?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubDataConnectionArgs].
 */
@PulumiTagMarker
public class EventHubDataConnectionArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var compression: Output<Either<String, Compression>>? = null

    private var consumerGroup: Output<String>? = null

    private var dataConnectionName: Output<String>? = null

    private var dataFormat: Output<Either<String, EventHubDataFormat>>? = null

    private var databaseName: Output<String>? = null

    private var databaseRouting: Output<Either<String, DatabaseRouting>>? = null

    private var eventHubResourceId: Output<String>? = null

    private var eventSystemProperties: Output<List<String>>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedIdentityResourceId: Output<String>? = null

    private var mappingRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retrievalStartDate: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("abvmhptpwtkuhikb")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("pwiomhqthcobbhnr")
    public suspend fun compression(`value`: Output<Either<String, Compression>>) {
        this.compression = value
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("dnmebcnaroodvece")
    public suspend fun consumerGroup(`value`: Output<String>) {
        this.consumerGroup = value
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("wquedlirwbecjaop")
    public suspend fun dataConnectionName(`value`: Output<String>) {
        this.dataConnectionName = value
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("irxnyjbkgfkwteih")
    public suspend fun dataFormat(`value`: Output<Either<String, EventHubDataFormat>>) {
        this.dataFormat = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("mdqdwivurjavirvx")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("ttogwlucbpqmrnme")
    public suspend fun databaseRouting(`value`: Output<Either<String, DatabaseRouting>>) {
        this.databaseRouting = value
    }

    /**
     * @param value The resource ID of the event hub to be used to create a data connection.
     */
    @JvmName("tjmmhbtreeaxxvml")
    public suspend fun eventHubResourceId(`value`: Output<String>) {
        this.eventHubResourceId = value
    }

    /**
     * @param value System properties of the event hub
     */
    @JvmName("nqralitbxwduqltt")
    public suspend fun eventSystemProperties(`value`: Output<List<String>>) {
        this.eventSystemProperties = value
    }

    @JvmName("ylfsfmdimutrcpxr")
    public suspend fun eventSystemProperties(vararg values: Output<String>) {
        this.eventSystemProperties = Output.all(values.asList())
    }

    /**
     * @param values System properties of the event hub
     */
    @JvmName("ahrebwhbodyxwbvo")
    public suspend fun eventSystemProperties(values: List<Output<String>>) {
        this.eventSystemProperties = Output.all(values)
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventHub'.
     */
    @JvmName("ylojgoaofcqcsubl")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dfvahevgtktmlctx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
     */
    @JvmName("gfyelbcfwlcwksix")
    public suspend fun managedIdentityResourceId(`value`: Output<String>) {
        this.managedIdentityResourceId = value
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("stjmnywagfcuebcy")
    public suspend fun mappingRuleName(`value`: Output<String>) {
        this.mappingRuleName = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("floeofsdpcgpfvap")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
     */
    @JvmName("woiqbbgakgkjuqko")
    public suspend fun retrievalStartDate(`value`: Output<String>) {
        this.retrievalStartDate = value
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("kpgmdssgxtoypneg")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("kgxighbmvucfqumt")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("lqdcfwlmmuufivby")
    public suspend fun compression(`value`: Either<String, Compression>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("jhbxccfxvjoalslo")
    public fun compression(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Compression>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The event hub messages compression type
     */
    @JvmName("bsprxtixmdqkpkuv")
    public fun compression(`value`: Compression) {
        val toBeMapped = Either.ofRight<String, Compression>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The event hub consumer group.
     */
    @JvmName("pmdhbcndyhyvmwco")
    public suspend fun consumerGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroup = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("rlddkajqhstoqyyc")
    public suspend fun dataConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("ihptgbfpbpuedjke")
    public suspend fun dataFormat(`value`: Either<String, EventHubDataFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("uyvucvxcrrneoapx")
    public fun dataFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The data format of the message. Optionally the data format can be added to each message.
     */
    @JvmName("acwdfuswwabnicjw")
    public fun dataFormat(`value`: EventHubDataFormat) {
        val toBeMapped = Either.ofRight<String, EventHubDataFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("hntmsgynptwkdifs")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("hnxjaajcrjwomgll")
    public suspend fun databaseRouting(`value`: Either<String, DatabaseRouting>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("ibqrcicxvrdnsslp")
    public fun databaseRouting(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    @JvmName("ksgwgcjexwwoglmi")
    public fun databaseRouting(`value`: DatabaseRouting) {
        val toBeMapped = Either.ofRight<String, DatabaseRouting>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseRouting = mapped
    }

    /**
     * @param value The resource ID of the event hub to be used to create a data connection.
     */
    @JvmName("kkprxsawjphekvmf")
    public suspend fun eventHubResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubResourceId = mapped
    }

    /**
     * @param value System properties of the event hub
     */
    @JvmName("vunfpwvelhftlvgi")
    public suspend fun eventSystemProperties(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param values System properties of the event hub
     */
    @JvmName("ttbusekwfsmqisgl")
    public suspend fun eventSystemProperties(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSystemProperties = mapped
    }

    /**
     * @param value Kind of the endpoint for the data connection
     * Expected value is 'EventHub'.
     */
    @JvmName("pnaarqhbxrqynjpc")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xlwexiwhihdaooqi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource ID of a managed identity (system or user assigned) to be used to authenticate with event hub.
     */
    @JvmName("ynshnjoddupcedau")
    public suspend fun managedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentityResourceId = mapped
    }

    /**
     * @param value The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    @JvmName("ldyqbiegcdxmmulu")
    public suspend fun mappingRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mappingRuleName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("dqyclaokwrdikftp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
     */
    @JvmName("yevtyjldsvtjcrck")
    public suspend fun retrievalStartDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retrievalStartDate = mapped
    }

    /**
     * @param value The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    @JvmName("sfslqillyojwfdsq")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): EventHubDataConnectionArgs = EventHubDataConnectionArgs(
        clusterName = clusterName,
        compression = compression,
        consumerGroup = consumerGroup,
        dataConnectionName = dataConnectionName,
        dataFormat = dataFormat,
        databaseName = databaseName,
        databaseRouting = databaseRouting,
        eventHubResourceId = eventHubResourceId,
        eventSystemProperties = eventSystemProperties,
        kind = kind,
        location = location,
        managedIdentityResourceId = managedIdentityResourceId,
        mappingRuleName = mappingRuleName,
        resourceGroupName = resourceGroupName,
        retrievalStartDate = retrievalStartDate,
        tableName = tableName,
    )
}
