@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [IotHubDataConnection].
 */
@PulumiTagMarker
public class IotHubDataConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotHubDataConnectionArgs = IotHubDataConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IotHubDataConnectionArgsBuilder.() -> Unit) {
        val builder = IotHubDataConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IotHubDataConnection {
        val builtJavaResource =
            com.pulumi.azurenative.kusto.IotHubDataConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IotHubDataConnection(builtJavaResource)
    }
}

/**
 * Class representing an iot hub data connection.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### KustoDataConnectionsCosmosDbCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubDataConnection = new AzureNative.Kusto.IotHubDataConnection("iotHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase1",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewIotHubDataConnection(ctx, "iotHubDataConnection", &kusto.IotHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase1"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.IotHubDataConnection;
 * import com.pulumi.azurenative.kusto.IotHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubDataConnection = new IotHubDataConnection("iotHubDataConnection", IotHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase1")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubDataConnection = new AzureNative.Kusto.IotHubDataConnection("iotHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewIotHubDataConnection(ctx, "iotHubDataConnection", &kusto.IotHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.IotHubDataConnection;
 * import com.pulumi.azurenative.kusto.IotHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubDataConnection = new IotHubDataConnection("iotHubDataConnection", IotHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### KustoDataConnectionsEventGridCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubDataConnection = new AzureNative.Kusto.IotHubDataConnection("iotHubDataConnection", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DataConnectionName = "dataConnectionTest",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewIotHubDataConnection(ctx, "iotHubDataConnection", &kusto.IotHubDataConnectionArgs{
 * 			ClusterName:        pulumi.String("kustoCluster"),
 * 			DataConnectionName: pulumi.String("dataConnectionTest"),
 * 			DatabaseName:       pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName:  pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.IotHubDataConnection;
 * import com.pulumi.azurenative.kusto.IotHubDataConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubDataConnection = new IotHubDataConnection("iotHubDataConnection", IotHubDataConnectionArgs.builder()
 *             .clusterName("kustoCluster")
 *             .dataConnectionName("dataConnectionTest")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:IotHubDataConnection kustoCluster/KustoDatabase8/dataConnectionTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}
 * ```
 */
public class IotHubDataConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.IotHubDataConnection,
) : KotlinCustomResource(javaResource, IotHubDataConnectionMapper) {
    /**
     * The iot hub consumer group.
     */
    public val consumerGroup: Output<String>
        get() = javaResource.consumerGroup().applyValue({ args0 -> args0 })

    /**
     * The data format of the message. Optionally the data format can be added to each message.
     */
    public val dataFormat: Output<String>?
        get() = javaResource.dataFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indication for database routing information from the data connection, by default only database routing information is allowed
     */
    public val databaseRouting: Output<String>?
        get() = javaResource.databaseRouting().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * System properties of the iot hub
     */
    public val eventSystemProperties: Output<List<String>>?
        get() = javaResource.eventSystemProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The resource ID of the Iot hub to be used to create a data connection.
     */
    public val iotHubResourceId: Output<String>
        get() = javaResource.iotHubResourceId().applyValue({ args0 -> args0 })

    /**
     * Kind of the endpoint for the data connection
     * Expected value is 'IotHub'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
     */
    public val mappingRuleName: Output<String>?
        get() = javaResource.mappingRuleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * When defined, the data connection retrieves existing Event hub events created since the Retrieval start date. It can only retrieve events retained by the Event hub, based on its retention period.
     */
    public val retrievalStartDate: Output<String>?
        get() = javaResource.retrievalStartDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the share access policy
     */
    public val sharedAccessPolicyName: Output<String>
        get() = javaResource.sharedAccessPolicyName().applyValue({ args0 -> args0 })

    /**
     * The table where the data should be ingested. Optionally the table information can be added to each message.
     */
    public val tableName: Output<String>?
        get() = javaResource.tableName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IotHubDataConnectionMapper : ResourceMapper<IotHubDataConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.IotHubDataConnection::class == javaResource::class

    override fun map(javaResource: Resource): IotHubDataConnection = IotHubDataConnection(
        javaResource
            as com.pulumi.azurenative.kusto.IotHubDataConnection,
    )
}

/**
 * @see [IotHubDataConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotHubDataConnection].
 */
public suspend fun iotHubDataConnection(
    name: String,
    block: suspend IotHubDataConnectionResourceBuilder.() -> Unit,
): IotHubDataConnection {
    val builder = IotHubDataConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotHubDataConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotHubDataConnection(name: String): IotHubDataConnection {
    val builder = IotHubDataConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
