@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedPrivateEndpoint].
 */
@PulumiTagMarker
public class ManagedPrivateEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedPrivateEndpointArgs = ManagedPrivateEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedPrivateEndpointArgsBuilder.() -> Unit) {
        val builder = ManagedPrivateEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedPrivateEndpoint {
        val builtJavaResource =
            com.pulumi.azurenative.kusto.ManagedPrivateEndpoint(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedPrivateEndpoint(builtJavaResource)
    }
}

/**
 * Class representing a managed private endpoint.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-08-27.
 * Other available API versions: 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoManagedPrivateEndpointsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedPrivateEndpoint = new AzureNative.Kusto.ManagedPrivateEndpoint("managedPrivateEndpoint", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         GroupId = "blob",
 *         ManagedPrivateEndpointName = "managedPrivateEndpointTest",
 *         PrivateLinkResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/storageAccountTest",
 *         RequestMessage = "Please Approve.",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewManagedPrivateEndpoint(ctx, "managedPrivateEndpoint", &kusto.ManagedPrivateEndpointArgs{
 * 			ClusterName:                pulumi.String("kustoCluster"),
 * 			GroupId:                    pulumi.String("blob"),
 * 			ManagedPrivateEndpointName: pulumi.String("managedPrivateEndpointTest"),
 * 			PrivateLinkResourceId:      pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/storageAccountTest"),
 * 			RequestMessage:             pulumi.String("Please Approve."),
 * 			ResourceGroupName:          pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.ManagedPrivateEndpoint;
 * import com.pulumi.azurenative.kusto.ManagedPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedPrivateEndpoint = new ManagedPrivateEndpoint("managedPrivateEndpoint", ManagedPrivateEndpointArgs.builder()
 *             .clusterName("kustoCluster")
 *             .groupId("blob")
 *             .managedPrivateEndpointName("managedPrivateEndpointTest")
 *             .privateLinkResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/storageAccountTest")
 *             .requestMessage("Please Approve.")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:ManagedPrivateEndpoint kustoCluster/KustoDatabase8/managedPrivateEndpointTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/managedPrivateEndpoints/{managedPrivateEndpointName}
 * ```
 */
public class ManagedPrivateEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.kusto.ManagedPrivateEndpoint,
) : KotlinCustomResource(javaResource, ManagedPrivateEndpointMapper) {
    /**
     * The groupId in which the managed private endpoint is created.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARM resource ID of the resource for which the managed private endpoint is created.
     */
    public val privateLinkResourceId: Output<String>
        get() = javaResource.privateLinkResourceId().applyValue({ args0 -> args0 })

    /**
     * The region of the resource to which the managed private endpoint is created.
     */
    public val privateLinkResourceRegion: Output<String>?
        get() = javaResource.privateLinkResourceRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioned state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The user request message.
     */
    public val requestMessage: Output<String>?
        get() = javaResource.requestMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedPrivateEndpointMapper : ResourceMapper<ManagedPrivateEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.kusto.ManagedPrivateEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ManagedPrivateEndpoint =
        ManagedPrivateEndpoint(javaResource as com.pulumi.azurenative.kusto.ManagedPrivateEndpoint)
}

/**
 * @see [ManagedPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedPrivateEndpoint].
 */
public suspend fun managedPrivateEndpoint(
    name: String,
    block: suspend ManagedPrivateEndpointResourceBuilder.() -> Unit,
): ManagedPrivateEndpoint {
    val builder = ManagedPrivateEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedPrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedPrivateEndpoint(name: String): ManagedPrivateEndpoint {
    val builder = ManagedPrivateEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
