@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.ManagedPrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a managed private endpoint.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-08-27.
 * Other available API versions: 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoManagedPrivateEndpointsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedPrivateEndpoint = new AzureNative.Kusto.ManagedPrivateEndpoint("managedPrivateEndpoint", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         GroupId = "blob",
 *         ManagedPrivateEndpointName = "managedPrivateEndpointTest",
 *         PrivateLinkResourceId = "/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/storageAccountTest",
 *         RequestMessage = "Please Approve.",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewManagedPrivateEndpoint(ctx, "managedPrivateEndpoint", &kusto.ManagedPrivateEndpointArgs{
 * 			ClusterName:                pulumi.String("kustoCluster"),
 * 			GroupId:                    pulumi.String("blob"),
 * 			ManagedPrivateEndpointName: pulumi.String("managedPrivateEndpointTest"),
 * 			PrivateLinkResourceId:      pulumi.String("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/storageAccountTest"),
 * 			RequestMessage:             pulumi.String("Please Approve."),
 * 			ResourceGroupName:          pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.ManagedPrivateEndpoint;
 * import com.pulumi.azurenative.kusto.ManagedPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedPrivateEndpoint = new ManagedPrivateEndpoint("managedPrivateEndpoint", ManagedPrivateEndpointArgs.builder()
 *             .clusterName("kustoCluster")
 *             .groupId("blob")
 *             .managedPrivateEndpointName("managedPrivateEndpointTest")
 *             .privateLinkResourceId("/subscriptions/12345678-1234-1234-1234-123456789098/resourceGroups/kustorptest/providers/Microsoft.Storage/storageAccounts/storageAccountTest")
 *             .requestMessage("Please Approve.")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:ManagedPrivateEndpoint kustoCluster/KustoDatabase8/managedPrivateEndpointTest /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/managedPrivateEndpoints/{managedPrivateEndpointName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property groupId The groupId in which the managed private endpoint is created.
 * @property managedPrivateEndpointName The name of the managed private endpoint.
 * @property privateLinkResourceId The ARM resource ID of the resource for which the managed private endpoint is created.
 * @property privateLinkResourceRegion The region of the resource to which the managed private endpoint is created.
 * @property requestMessage The user request message.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class ManagedPrivateEndpointArgs(
    public val clusterName: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val managedPrivateEndpointName: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val privateLinkResourceRegion: Output<String>? = null,
    public val requestMessage: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.ManagedPrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.ManagedPrivateEndpointArgs =
        com.pulumi.azurenative.kusto.ManagedPrivateEndpointArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .managedPrivateEndpointName(managedPrivateEndpointName?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .privateLinkResourceRegion(privateLinkResourceRegion?.applyValue({ args0 -> args0 }))
            .requestMessage(requestMessage?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedPrivateEndpointArgs].
 */
@PulumiTagMarker
public class ManagedPrivateEndpointArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var groupId: Output<String>? = null

    private var managedPrivateEndpointName: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var privateLinkResourceRegion: Output<String>? = null

    private var requestMessage: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("jftpmnoiqxfxputu")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The groupId in which the managed private endpoint is created.
     */
    @JvmName("skqeurgxpkhrugxi")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The name of the managed private endpoint.
     */
    @JvmName("yoixotgwfqiuadni")
    public suspend fun managedPrivateEndpointName(`value`: Output<String>) {
        this.managedPrivateEndpointName = value
    }

    /**
     * @param value The ARM resource ID of the resource for which the managed private endpoint is created.
     */
    @JvmName("bpkxbuwlmhhtdbfr")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value The region of the resource to which the managed private endpoint is created.
     */
    @JvmName("nombydtdcmrxgknu")
    public suspend fun privateLinkResourceRegion(`value`: Output<String>) {
        this.privateLinkResourceRegion = value
    }

    /**
     * @param value The user request message.
     */
    @JvmName("jyujpklpgdvcbmbc")
    public suspend fun requestMessage(`value`: Output<String>) {
        this.requestMessage = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("svsfwjcvoiuqkfhc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("txqxecyqlnkmsora")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The groupId in which the managed private endpoint is created.
     */
    @JvmName("kipurskvkyofsndb")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The name of the managed private endpoint.
     */
    @JvmName("qivotruxkppegftv")
    public suspend fun managedPrivateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPrivateEndpointName = mapped
    }

    /**
     * @param value The ARM resource ID of the resource for which the managed private endpoint is created.
     */
    @JvmName("xkqcwkfjfjcghdbi")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value The region of the resource to which the managed private endpoint is created.
     */
    @JvmName("xbdrgydqfusnolgt")
    public suspend fun privateLinkResourceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceRegion = mapped
    }

    /**
     * @param value The user request message.
     */
    @JvmName("dffjcdokjsffjccr")
    public suspend fun requestMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMessage = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("waihxmidoxkxfats")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagedPrivateEndpointArgs = ManagedPrivateEndpointArgs(
        clusterName = clusterName,
        groupId = groupId,
        managedPrivateEndpointName = managedPrivateEndpointName,
        privateLinkResourceId = privateLinkResourceId,
        privateLinkResourceRegion = privateLinkResourceRegion,
        requestMessage = requestMessage,
        resourceGroupName = resourceGroupName,
    )
}
