@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a read only following database.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Kusto ReadOnly database update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readOnlyFollowingDatabase = new AzureNative.Kusto.ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DatabaseName = "kustoReadOnlyDatabase",
 *         HotCachePeriod = "P1D",
 *         Kind = "ReadOnlyFollowing",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewReadOnlyFollowingDatabase(ctx, "readOnlyFollowingDatabase", &kusto.ReadOnlyFollowingDatabaseArgs{
 * 			ClusterName:       pulumi.String("kustoCluster"),
 * 			DatabaseName:      pulumi.String("kustoReadOnlyDatabase"),
 * 			HotCachePeriod:    pulumi.String("P1D"),
 * 			Kind:              pulumi.String("ReadOnlyFollowing"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabase;
 * import com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readOnlyFollowingDatabase = new ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", ReadOnlyFollowingDatabaseArgs.builder()
 *             .clusterName("kustoCluster")
 *             .databaseName("kustoReadOnlyDatabase")
 *             .hotCachePeriod("P1D")
 *             .kind("ReadOnlyFollowing")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### Kusto ReadWrite database create or update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readOnlyFollowingDatabase = new AzureNative.Kusto.ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", new()
 *     {
 *         CallerRole = "Admin",
 *         ClusterName = "kustoCluster",
 *         DatabaseName = "KustoDatabase8",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewReadOnlyFollowingDatabase(ctx, "readOnlyFollowingDatabase", &kusto.ReadOnlyFollowingDatabaseArgs{
 * 			CallerRole:        pulumi.String("Admin"),
 * 			ClusterName:       pulumi.String("kustoCluster"),
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabase;
 * import com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readOnlyFollowingDatabase = new ReadOnlyFollowingDatabase("readOnlyFollowingDatabase", ReadOnlyFollowingDatabaseArgs.builder()
 *             .callerRole("Admin")
 *             .clusterName("kustoCluster")
 *             .databaseName("KustoDatabase8")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:ReadOnlyFollowingDatabase kustoCluster/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}
 * ```
 * @property callerRole By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude the caller from Admins list.
 * @property clusterName The name of the Kusto cluster.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property hotCachePeriod The time the data should be kept in cache for fast queries in TimeSpan.
 * @property kind Kind of the database
 * Expected value is 'ReadOnlyFollowing'.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class ReadOnlyFollowingDatabaseArgs(
    public val callerRole: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val hotCachePeriod: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabaseArgs =
        com.pulumi.azurenative.kusto.ReadOnlyFollowingDatabaseArgs.builder()
            .callerRole(callerRole?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .hotCachePeriod(hotCachePeriod?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReadOnlyFollowingDatabaseArgs].
 */
@PulumiTagMarker
public class ReadOnlyFollowingDatabaseArgsBuilder internal constructor() {
    private var callerRole: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var hotCachePeriod: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude the caller from Admins list.
     */
    @JvmName("ysxffgxnuabvlkco")
    public suspend fun callerRole(`value`: Output<String>) {
        this.callerRole = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("ggoiagxpifkfhwdg")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("jfpwvrwylsrrubhh")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("iqpifndcxulweape")
    public suspend fun hotCachePeriod(`value`: Output<String>) {
        this.hotCachePeriod = value
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadOnlyFollowing'.
     */
    @JvmName("xbxvicmquwsaohyw")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("itgagvytbjjfhvhj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("xcbrfhmrgnebwrcg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude the caller from Admins list.
     */
    @JvmName("ohygrbwvkvvbklgc")
    public suspend fun callerRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callerRole = mapped
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("riacxiqhoxlycghf")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("mgppyueaorrpjtpk")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("vsmvfefjqjjnubtn")
    public suspend fun hotCachePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hotCachePeriod = mapped
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadOnlyFollowing'.
     */
    @JvmName("huamywtlhoiwpuhg")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("afsdwqqaruowauld")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("myjkvwdeervsjvya")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ReadOnlyFollowingDatabaseArgs = ReadOnlyFollowingDatabaseArgs(
        callerRole = callerRole,
        clusterName = clusterName,
        databaseName = databaseName,
        hotCachePeriod = hotCachePeriod,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
    )
}
