@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.ReadWriteDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a read write database.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Kusto ReadOnly database update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readWriteDatabase = new AzureNative.Kusto.ReadWriteDatabase("readWriteDatabase", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         DatabaseName = "kustoReadOnlyDatabase",
 *         ResourceGroupName = "kustorptest",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewReadWriteDatabase(ctx, "readWriteDatabase", &kusto.ReadWriteDatabaseArgs{
 * 			ClusterName:       pulumi.String("kustoCluster"),
 * 			DatabaseName:      pulumi.String("kustoReadOnlyDatabase"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.ReadWriteDatabase;
 * import com.pulumi.azurenative.kusto.ReadWriteDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readWriteDatabase = new ReadWriteDatabase("readWriteDatabase", ReadWriteDatabaseArgs.builder()
 *             .clusterName("kustoCluster")
 *             .databaseName("kustoReadOnlyDatabase")
 *             .resourceGroupName("kustorptest")
 *             .build());
 *     }
 * }
 * ```
 * ### Kusto ReadWrite database create or update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var readWriteDatabase = new AzureNative.Kusto.ReadWriteDatabase("readWriteDatabase", new()
 *     {
 *         CallerRole = "Admin",
 *         ClusterName = "kustoCluster",
 *         DatabaseName = "KustoDatabase8",
 *         Kind = "ReadWrite",
 *         Location = "westus",
 *         ResourceGroupName = "kustorptest",
 *         SoftDeletePeriod = "P1D",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewReadWriteDatabase(ctx, "readWriteDatabase", &kusto.ReadWriteDatabaseArgs{
 * 			CallerRole:        pulumi.String("Admin"),
 * 			ClusterName:       pulumi.String("kustoCluster"),
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			Kind:              pulumi.String("ReadWrite"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 			SoftDeletePeriod:  pulumi.String("P1D"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.ReadWriteDatabase;
 * import com.pulumi.azurenative.kusto.ReadWriteDatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var readWriteDatabase = new ReadWriteDatabase("readWriteDatabase", ReadWriteDatabaseArgs.builder()
 *             .callerRole("Admin")
 *             .clusterName("kustoCluster")
 *             .databaseName("KustoDatabase8")
 *             .kind("ReadWrite")
 *             .location("westus")
 *             .resourceGroupName("kustorptest")
 *             .softDeletePeriod("P1D")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:ReadWriteDatabase kustoCluster/KustoDatabase8 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}
 * ```
 * @property callerRole By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude the caller from Admins list.
 * @property clusterName The name of the Kusto cluster.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property hotCachePeriod The time the data should be kept in cache for fast queries in TimeSpan.
 * @property kind Kind of the database
 * Expected value is 'ReadWrite'.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property softDeletePeriod The time the data should be kept before it stops being accessible to queries in TimeSpan.
 */
public data class ReadWriteDatabaseArgs(
    public val callerRole: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val hotCachePeriod: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val softDeletePeriod: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.ReadWriteDatabaseArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.ReadWriteDatabaseArgs =
        com.pulumi.azurenative.kusto.ReadWriteDatabaseArgs.builder()
            .callerRole(callerRole?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .hotCachePeriod(hotCachePeriod?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .softDeletePeriod(softDeletePeriod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReadWriteDatabaseArgs].
 */
@PulumiTagMarker
public class ReadWriteDatabaseArgsBuilder internal constructor() {
    private var callerRole: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var hotCachePeriod: Output<String>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var softDeletePeriod: Output<String>? = null

    /**
     * @param value By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude the caller from Admins list.
     */
    @JvmName("heuxrqoyplflvmle")
    public suspend fun callerRole(`value`: Output<String>) {
        this.callerRole = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("xitykwpfakxorrbd")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("ujfwtpciyillwdxp")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("vmeunfytfeprplss")
    public suspend fun hotCachePeriod(`value`: Output<String>) {
        this.hotCachePeriod = value
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadWrite'.
     */
    @JvmName("ldprbutrqmgnpqpi")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("rxxaxytflfmlmxsg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("bhmeqwvuqxyiempg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The time the data should be kept before it stops being accessible to queries in TimeSpan.
     */
    @JvmName("plrvwheawtyttuep")
    public suspend fun softDeletePeriod(`value`: Output<String>) {
        this.softDeletePeriod = value
    }

    /**
     * @param value By default, any user who run operation on a database become an Admin on it. This property allows the caller to exclude the caller from Admins list.
     */
    @JvmName("pxtcbdoyfxvsuxjc")
    public suspend fun callerRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callerRole = mapped
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("gqaueonrikmqivuh")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("lmqeljefelqetcci")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The time the data should be kept in cache for fast queries in TimeSpan.
     */
    @JvmName("gbdoaolkxmljewjy")
    public suspend fun hotCachePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hotCachePeriod = mapped
    }

    /**
     * @param value Kind of the database
     * Expected value is 'ReadWrite'.
     */
    @JvmName("mljbachuufujdpin")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jwgdqhktrfqjmpoe")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("liavrfbilywpqvsh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The time the data should be kept before it stops being accessible to queries in TimeSpan.
     */
    @JvmName("bvfutecgklitxiwn")
    public suspend fun softDeletePeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeletePeriod = mapped
    }

    internal fun build(): ReadWriteDatabaseArgs = ReadWriteDatabaseArgs(
        callerRole = callerRole,
        clusterName = clusterName,
        databaseName = databaseName,
        hotCachePeriod = hotCachePeriod,
        kind = kind,
        location = location,
        resourceGroupName = resourceGroupName,
        softDeletePeriod = softDeletePeriod,
    )
}
