@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin

import com.pulumi.azurenative.kusto.ScriptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class representing a database script.
 * Azure REST API version: 2022-12-29. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2021-08-27, 2023-05-02, 2023-08-15.
 * ## Example Usage
 * ### KustoScriptsCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var script = new AzureNative.Kusto.Script("script", new()
 *     {
 *         ClusterName = "kustoCluster",
 *         ContinueOnErrors = true,
 *         DatabaseName = "KustoDatabase8",
 *         ForceUpdateTag = "2bcf3c21-ffd1-4444-b9dd-e52e00ee53fe",
 *         ResourceGroupName = "kustorptest",
 *         ScriptName = "kustoScript",
 *         ScriptUrl = "https://mysa.blob.core.windows.net/container/script.txt",
 *         ScriptUrlSasToken = "?sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=********************************",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/kusto/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kusto.NewScript(ctx, "script", &kusto.ScriptArgs{
 * 			ClusterName:       pulumi.String("kustoCluster"),
 * 			ContinueOnErrors:  pulumi.Bool(true),
 * 			DatabaseName:      pulumi.String("KustoDatabase8"),
 * 			ForceUpdateTag:    pulumi.String("2bcf3c21-ffd1-4444-b9dd-e52e00ee53fe"),
 * 			ResourceGroupName: pulumi.String("kustorptest"),
 * 			ScriptName:        pulumi.String("kustoScript"),
 * 			ScriptUrl:         pulumi.String("https://mysa.blob.core.windows.net/container/script.txt"),
 * 			ScriptUrlSasToken: pulumi.String("?sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=********************************"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.kusto.Script;
 * import com.pulumi.azurenative.kusto.ScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var script = new Script("script", ScriptArgs.builder()
 *             .clusterName("kustoCluster")
 *             .continueOnErrors(true)
 *             .databaseName("KustoDatabase8")
 *             .forceUpdateTag("2bcf3c21-ffd1-4444-b9dd-e52e00ee53fe")
 *             .resourceGroupName("kustorptest")
 *             .scriptName("kustoScript")
 *             .scriptUrl("https://mysa.blob.core.windows.net/container/script.txt")
 *             .scriptUrlSasToken("?sv=2019-02-02&st=2019-04-29T22%3A18%3A26Z&se=2019-04-30T02%3A23%3A26Z&sr=b&sp=rw&sip=168.1.5.60-168.1.5.70&spr=https&sig=********************************")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:kusto:Script kustoCluster/KustoDatabase8/kustoScript /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scripts/{scriptName}
 * ```
 * @property clusterName The name of the Kusto cluster.
 * @property continueOnErrors Flag that indicates whether to continue if one of the command fails.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property forceUpdateTag A unique string. If changed the script will be applied again.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 * @property scriptContent The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with scriptUrl and scriptUrlSasToken properties.
 * @property scriptName The name of the Kusto database script.
 * @property scriptUrl The url to the KQL script blob file. Must not be used together with scriptContent property
 * @property scriptUrlSasToken The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property.
 */
public data class ScriptArgs(
    public val clusterName: Output<String>? = null,
    public val continueOnErrors: Output<Boolean>? = null,
    public val databaseName: Output<String>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scriptContent: Output<String>? = null,
    public val scriptName: Output<String>? = null,
    public val scriptUrl: Output<String>? = null,
    public val scriptUrlSasToken: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.ScriptArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.ScriptArgs =
        com.pulumi.azurenative.kusto.ScriptArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .continueOnErrors(continueOnErrors?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scriptContent(scriptContent?.applyValue({ args0 -> args0 }))
            .scriptName(scriptName?.applyValue({ args0 -> args0 }))
            .scriptUrl(scriptUrl?.applyValue({ args0 -> args0 }))
            .scriptUrlSasToken(scriptUrlSasToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptArgs].
 */
@PulumiTagMarker
public class ScriptArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var continueOnErrors: Output<Boolean>? = null

    private var databaseName: Output<String>? = null

    private var forceUpdateTag: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scriptContent: Output<String>? = null

    private var scriptName: Output<String>? = null

    private var scriptUrl: Output<String>? = null

    private var scriptUrlSasToken: Output<String>? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("ofocajsuiethukcu")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Flag that indicates whether to continue if one of the command fails.
     */
    @JvmName("witlpmcrcxabnkmw")
    public suspend fun continueOnErrors(`value`: Output<Boolean>) {
        this.continueOnErrors = value
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("vlsasjdnqlvqgskl")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value A unique string. If changed the script will be applied again.
     */
    @JvmName("ojrgtodphsyreipm")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("qjfsikjiqufgggom")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with scriptUrl and scriptUrlSasToken properties.
     */
    @JvmName("jtotplivcvhwayqv")
    public suspend fun scriptContent(`value`: Output<String>) {
        this.scriptContent = value
    }

    /**
     * @param value The name of the Kusto database script.
     */
    @JvmName("lbdhblqkgebauikg")
    public suspend fun scriptName(`value`: Output<String>) {
        this.scriptName = value
    }

    /**
     * @param value The url to the KQL script blob file. Must not be used together with scriptContent property
     */
    @JvmName("oifqattfiaenntor")
    public suspend fun scriptUrl(`value`: Output<String>) {
        this.scriptUrl = value
    }

    /**
     * @param value The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property.
     */
    @JvmName("fgtmglresiynaasx")
    public suspend fun scriptUrlSasToken(`value`: Output<String>) {
        this.scriptUrlSasToken = value
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("srbytlhjcyeooucw")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Flag that indicates whether to continue if one of the command fails.
     */
    @JvmName("hmlprpfsnffrsjvd")
    public suspend fun continueOnErrors(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.continueOnErrors = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("tgchtefyblnvhfkt")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value A unique string. If changed the script will be applied again.
     */
    @JvmName("sbskvgxujjsleubh")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("pkticmjewnkvdycw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The script content. This property should be used when the script is provide inline and not through file in a SA. Must not be used together with scriptUrl and scriptUrlSasToken properties.
     */
    @JvmName("bfcjqjkapcsivuef")
    public suspend fun scriptContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptContent = mapped
    }

    /**
     * @param value The name of the Kusto database script.
     */
    @JvmName("lssluagtssliukqq")
    public suspend fun scriptName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptName = mapped
    }

    /**
     * @param value The url to the KQL script blob file. Must not be used together with scriptContent property
     */
    @JvmName("ycveyetwngvcuxyd")
    public suspend fun scriptUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptUrl = mapped
    }

    /**
     * @param value The SaS token that provide read access to the file which contain the script. Must be provided when using scriptUrl property.
     */
    @JvmName("ikrogmqewfqteqak")
    public suspend fun scriptUrlSasToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptUrlSasToken = mapped
    }

    internal fun build(): ScriptArgs = ScriptArgs(
        clusterName = clusterName,
        continueOnErrors = continueOnErrors,
        databaseName = databaseName,
        forceUpdateTag = forceUpdateTag,
        resourceGroupName = resourceGroupName,
        scriptContent = scriptContent,
        scriptName = scriptName,
        scriptUrl = scriptUrl,
        scriptUrlSasToken = scriptUrlSasToken,
    )
}
