@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The data format of the message. Optionally the data format can be added to each message.
 */
public enum class EventGridDataFormat(
    public val javaValue: com.pulumi.azurenative.kusto.enums.EventGridDataFormat,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.EventGridDataFormat> {
    MULTIJSON(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.MULTIJSON),
    JSON(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.JSON),
    CSV(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.CSV),
    TSV(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.TSV),
    SCSV(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.SCSV),
    SOHSV(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.SOHSV),
    PSV(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.PSV),
    TXT(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.TXT),
    RAW(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.RAW),
    SINGLEJSON(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.SINGLEJSON),
    AVRO(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.AVRO),
    TSVE(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.TSVE),
    PARQUET(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.PARQUET),
    ORC(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.ORC),
    APACHEAVRO(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.APACHEAVRO),
    W3CLOGFILE(com.pulumi.azurenative.kusto.enums.EventGridDataFormat.W3CLOGFILE),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.EventGridDataFormat = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.EventGridDataFormat):
            EventGridDataFormat = EventGridDataFormat.values().first { it.javaValue == javaType }
    }
}
