@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6)
 */
public enum class PublicIPType(
    public val javaValue: com.pulumi.azurenative.kusto.enums.PublicIPType,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.PublicIPType> {
    IPv4(com.pulumi.azurenative.kusto.enums.PublicIPType.IPv4),
    DualStack(com.pulumi.azurenative.kusto.enums.PublicIPType.DualStack),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.PublicIPType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.PublicIPType): PublicIPType =
            PublicIPType.values().first { it.javaValue == javaType }
    }
}
