@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Public network access to the cluster is enabled by default. When disabled, only private endpoint connection to the cluster is allowed
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.kusto.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.kusto.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.kusto.enums.PublicNetworkAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.kusto.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
