@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.AcceptedAudiencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an accepted audience trusted by the cluster.
 * @property value GUID or valid URL representing an accepted audience.
 */
public data class AcceptedAudiencesArgs(
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.AcceptedAudiencesArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.AcceptedAudiencesArgs =
        com.pulumi.azurenative.kusto.inputs.AcceptedAudiencesArgs.builder()
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AcceptedAudiencesArgs].
 */
@PulumiTagMarker
public class AcceptedAudiencesArgsBuilder internal constructor() {
    private var `value`: Output<String>? = null

    /**
     * @param value GUID or valid URL representing an accepted audience.
     */
    @JvmName("oqitgnjvnrfonegp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value GUID or valid URL representing an accepted audience.
     */
    @JvmName("fjjrmfnuqughjnae")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AcceptedAudiencesArgs = AcceptedAudiencesArgs(
        `value` = `value`,
    )
}
