@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetAttachedDatabaseConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attachedDatabaseConfigurationName The name of the attached database configuration.
 * @property clusterName The name of the Kusto cluster.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetAttachedDatabaseConfigurationPlainArgs(
    public val attachedDatabaseConfigurationName: String,
    public val clusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetAttachedDatabaseConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.kusto.inputs.GetAttachedDatabaseConfigurationPlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetAttachedDatabaseConfigurationPlainArgs.builder()
            .attachedDatabaseConfigurationName(attachedDatabaseConfigurationName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttachedDatabaseConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetAttachedDatabaseConfigurationPlainArgsBuilder internal constructor() {
    private var attachedDatabaseConfigurationName: String? = null

    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the attached database configuration.
     */
    @JvmName("hjfbsjceikwvqkop")
    public suspend fun attachedDatabaseConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attachedDatabaseConfigurationName = mapped
    }

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("jvgnpbyjlmswicay")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("cyaejyiqdgedkeff")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAttachedDatabaseConfigurationPlainArgs =
        GetAttachedDatabaseConfigurationPlainArgs(
            attachedDatabaseConfigurationName = attachedDatabaseConfigurationName ?: throw
                PulumiNullFieldException("attachedDatabaseConfigurationName"),
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
