@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetClusterPrincipalAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property principalAssignmentName The name of the Kusto principalAssignment.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetClusterPrincipalAssignmentPlainArgs(
    public val clusterName: String,
    public val principalAssignmentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetClusterPrincipalAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetClusterPrincipalAssignmentPlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetClusterPrincipalAssignmentPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .principalAssignmentName(principalAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterPrincipalAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetClusterPrincipalAssignmentPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var principalAssignmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("hfpudlvmjrrenloh")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the Kusto principalAssignment.
     */
    @JvmName("wfcocuqbnxvhvqqg")
    public suspend fun principalAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalAssignmentName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("ajhhqitwkfprpnow")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetClusterPrincipalAssignmentPlainArgs =
        GetClusterPrincipalAssignmentPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            principalAssignmentName = principalAssignmentName ?: throw
                PulumiNullFieldException("principalAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
