@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.inputs

import com.pulumi.azurenative.kusto.inputs.GetIotHubDataConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the Kusto cluster.
 * @property dataConnectionName The name of the data connection.
 * @property databaseName The name of the database in the Kusto cluster.
 * @property resourceGroupName The name of the resource group containing the Kusto cluster.
 */
public data class GetIotHubDataConnectionPlainArgs(
    public val clusterName: String,
    public val dataConnectionName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.kusto.inputs.GetIotHubDataConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.kusto.inputs.GetIotHubDataConnectionPlainArgs =
        com.pulumi.azurenative.kusto.inputs.GetIotHubDataConnectionPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .dataConnectionName(dataConnectionName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIotHubDataConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetIotHubDataConnectionPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var dataConnectionName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Kusto cluster.
     */
    @JvmName("sphwcbcovgqwfque")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the data connection.
     */
    @JvmName("njqjyhhlcnjwgwvm")
    public suspend fun dataConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataConnectionName = mapped
    }

    /**
     * @param value The name of the database in the Kusto cluster.
     */
    @JvmName("tgkkejxxhkvotsha")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group containing the Kusto cluster.
     */
    @JvmName("otjnuvxanckaqdrb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIotHubDataConnectionPlainArgs = GetIotHubDataConnectionPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        dataConnectionName = dataConnectionName ?: throw PulumiNullFieldException("dataConnectionName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
