@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing an event hub connection.
 * @property consumerGroup The event hub consumer group.
 * @property dataFormat The data format of the message. Optionally the data format can be added to each message.
 * @property eventHubResourceId The resource ID of the event hub to be used to create a data connection.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location Resource location.
 * @property mappingRuleName The mapping rule to be used to ingest the data. Optionally the mapping information can be added to each message.
 * @property name The name of the resource
 * @property tableName The table where the data should be ingested. Optionally the table information can be added to each message.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEventHubConnectionResult(
    public val consumerGroup: String,
    public val dataFormat: String? = null,
    public val eventHubResourceId: String,
    public val id: String,
    public val location: String? = null,
    public val mappingRuleName: String? = null,
    public val name: String,
    public val tableName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetEventHubConnectionResult):
            GetEventHubConnectionResult = GetEventHubConnectionResult(
            consumerGroup = javaType.consumerGroup(),
            dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
            eventHubResourceId = javaType.eventHubResourceId(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            mappingRuleName = javaType.mappingRuleName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tableName = javaType.tableName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
