@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Class representing a database script.
 * @property continueOnErrors Flag that indicates whether to continue if one of the command fails.
 * @property forceUpdateTag A unique string. If changed the script will be applied again.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The provisioned state of the resource.
 * @property scriptUrl The url to the KQL script blob file. Must not be used together with scriptContent property
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetScriptResult(
    public val continueOnErrors: Boolean? = null,
    public val forceUpdateTag: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val scriptUrl: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.GetScriptResult):
            GetScriptResult = GetScriptResult(
            continueOnErrors = javaType.continueOnErrors().map({ args0 -> args0 }).orElse(null),
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scriptUrl = javaType.scriptUrl().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.kusto.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
