@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.kusto.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class that contains virtual network definition.
 * @property dataManagementPublicIpId Data management's service public IP address resource id.
 * @property enginePublicIpId Engine service's public IP address resource id.
 * @property subnetId The subnet resource id.
 */
public data class VirtualNetworkConfigurationResponse(
    public val dataManagementPublicIpId: String,
    public val enginePublicIpId: String,
    public val subnetId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.kusto.outputs.VirtualNetworkConfigurationResponse):
            VirtualNetworkConfigurationResponse = VirtualNetworkConfigurationResponse(
            dataManagementPublicIpId = javaType.dataManagementPublicIpId(),
            enginePublicIpId = javaType.enginePublicIpId(),
            subnetId = javaType.subnetId(),
        )
    }
}
