@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin

import com.pulumi.azurenative.labservices.kotlin.outputs.AutoShutdownProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.ConnectionProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.LabPlanNetworkProfileResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.SupportInfoResponse
import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.labservices.kotlin.outputs.AutoShutdownProfileResponse.Companion.toKotlin as autoShutdownProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.ConnectionProfileResponse.Companion.toKotlin as connectionProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.LabPlanNetworkProfileResponse.Companion.toKotlin as labPlanNetworkProfileResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.SupportInfoResponse.Companion.toKotlin as supportInfoResponseToKotlin
import com.pulumi.azurenative.labservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LabPlan].
 */
@PulumiTagMarker
public class LabPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabPlanArgs = LabPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabPlanArgsBuilder.() -> Unit) {
        val builder = LabPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LabPlan {
        val builtJavaResource = com.pulumi.azurenative.labservices.LabPlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LabPlan(builtJavaResource)
    }
}

/**
 * Lab Plans act as a permission container for creating labs via labs.azure.com. Additionally, they can provide a set of default configurations that will apply at the time of creating a lab, but these defaults can still be overwritten.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2023-06-07.
 * ## Example Usage
 * ### putLabPlan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var labPlan = new AzureNative.LabServices.LabPlan("labPlan", new()
 *     {
 *         DefaultAutoShutdownProfile = new AzureNative.LabServices.Inputs.AutoShutdownProfileArgs
 *         {
 *             DisconnectDelay = "PT5M",
 *             IdleDelay = "PT5M",
 *             NoConnectDelay = "PT5M",
 *             ShutdownOnDisconnect = AzureNative.LabServices.EnableState.Enabled,
 *             ShutdownOnIdle = AzureNative.LabServices.ShutdownOnIdleMode.UserAbsence,
 *             ShutdownWhenNotConnected = AzureNative.LabServices.EnableState.Enabled,
 *         },
 *         DefaultConnectionProfile = new AzureNative.LabServices.Inputs.ConnectionProfileArgs
 *         {
 *             ClientRdpAccess = AzureNative.LabServices.ConnectionType.Public,
 *             ClientSshAccess = AzureNative.LabServices.ConnectionType.Public,
 *             WebRdpAccess = AzureNative.LabServices.ConnectionType.None,
 *             WebSshAccess = AzureNative.LabServices.ConnectionType.None,
 *         },
 *         DefaultNetworkProfile = new AzureNative.LabServices.Inputs.LabPlanNetworkProfileArgs
 *         {
 *             SubnetId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default",
 *         },
 *         LabPlanName = "testlabplan",
 *         Location = "westus",
 *         ResourceGroupName = "testrg123",
 *         SharedGalleryId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Compute/galleries/testsig",
 *         SupportInfo = new AzureNative.LabServices.Inputs.SupportInfoArgs
 *         {
 *             Email = "help@contoso.com",
 *             Instructions = "Contact support for help.",
 *             Phone = "+1-202-555-0123",
 *             Url = "help.contoso.com",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/labservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := labservices.NewLabPlan(ctx, "labPlan", &labservices.LabPlanArgs{
 * 			DefaultAutoShutdownProfile: &labservices.AutoShutdownProfileArgs{
 * 				DisconnectDelay:          pulumi.String("PT5M"),
 * 				IdleDelay:                pulumi.String("PT5M"),
 * 				NoConnectDelay:           pulumi.String("PT5M"),
 * 				ShutdownOnDisconnect:     labservices.EnableStateEnabled,
 * 				ShutdownOnIdle:           labservices.ShutdownOnIdleModeUserAbsence,
 * 				ShutdownWhenNotConnected: labservices.EnableStateEnabled,
 * 			},
 * 			DefaultConnectionProfile: &labservices.ConnectionProfileArgs{
 * 				ClientRdpAccess: labservices.ConnectionTypePublic,
 * 				ClientSshAccess: labservices.ConnectionTypePublic,
 * 				WebRdpAccess:    labservices.ConnectionTypeNone,
 * 				WebSshAccess:    labservices.ConnectionTypeNone,
 * 			},
 * 			DefaultNetworkProfile: &labservices.LabPlanNetworkProfileArgs{
 * 				SubnetId: pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"),
 * 			},
 * 			LabPlanName:       pulumi.String("testlabplan"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			SharedGalleryId:   pulumi.String("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Compute/galleries/testsig"),
 * 			SupportInfo: &labservices.SupportInfoArgs{
 * 				Email:        pulumi.String("help@contoso.com"),
 * 				Instructions: pulumi.String("Contact support for help."),
 * 				Phone:        pulumi.String("+1-202-555-0123"),
 * 				Url:          pulumi.String("help.contoso.com"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.labservices.LabPlan;
 * import com.pulumi.azurenative.labservices.LabPlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var labPlan = new LabPlan("labPlan", LabPlanArgs.builder()
 *             .defaultAutoShutdownProfile(Map.ofEntries(
 *                 Map.entry("disconnectDelay", "PT5M"),
 *                 Map.entry("idleDelay", "PT5M"),
 *                 Map.entry("noConnectDelay", "PT5M"),
 *                 Map.entry("shutdownOnDisconnect", "Enabled"),
 *                 Map.entry("shutdownOnIdle", "UserAbsence"),
 *                 Map.entry("shutdownWhenNotConnected", "Enabled")
 *             ))
 *             .defaultConnectionProfile(Map.ofEntries(
 *                 Map.entry("clientRdpAccess", "Public"),
 *                 Map.entry("clientSshAccess", "Public"),
 *                 Map.entry("webRdpAccess", "None"),
 *                 Map.entry("webSshAccess", "None")
 *             ))
 *             .defaultNetworkProfile(Map.of("subnetId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/default"))
 *             .labPlanName("testlabplan")
 *             .location("westus")
 *             .resourceGroupName("testrg123")
 *             .sharedGalleryId("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testrg123/providers/Microsoft.Compute/galleries/testsig")
 *             .supportInfo(Map.ofEntries(
 *                 Map.entry("email", "help@contoso.com"),
 *                 Map.entry("instructions", "Contact support for help."),
 *                 Map.entry("phone", "+1-202-555-0123"),
 *                 Map.entry("url", "help.contoso.com")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:labservices:LabPlan testlabplan /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LabServices/labPlans/{labPlanName}
 * ```
 */
public class LabPlan internal constructor(
    override val javaResource: com.pulumi.azurenative.labservices.LabPlan,
) : KotlinCustomResource(javaResource, LabPlanMapper) {
    /**
     * The allowed regions for the lab creator to use when creating labs using this lab plan.
     */
    public val allowedRegions: Output<List<String>>?
        get() = javaResource.allowedRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The default lab shutdown profile. This can be changed on a lab resource and only provides a default profile.
     */
    public val defaultAutoShutdownProfile: Output<AutoShutdownProfileResponse>?
        get() = javaResource.defaultAutoShutdownProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> autoShutdownProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The default lab connection profile. This can be changed on a lab resource and only provides a default profile.
     */
    public val defaultConnectionProfile: Output<ConnectionProfileResponse>?
        get() = javaResource.defaultConnectionProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> connectionProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The lab plan network profile. To enforce lab network policies they must be defined here and cannot be changed when there are existing labs associated with this lab plan.
     */
    public val defaultNetworkProfile: Output<LabPlanNetworkProfileResponse>?
        get() = javaResource.defaultNetworkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> labPlanNetworkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Managed Identity Information
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Base Url of the lms instance this lab plan can link lab rosters against.
     */
    public val linkedLmsInstance: Output<String>?
        get() = javaResource.linkedLmsInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Current provisioning state of the lab plan.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource ID of the Shared Image Gallery attached to this lab plan. When saving a lab template virtual machine image it will be persisted in this gallery. Shared images from the gallery can be made available to use when creating new labs.
     */
    public val sharedGalleryId: Output<String>?
        get() = javaResource.sharedGalleryId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Support contact information and instructions for users of the lab plan. This information is displayed to lab owners and virtual machine users for all labs in the lab plan.
     */
    public val supportInfo: Output<SupportInfoResponse>?
        get() = javaResource.supportInfo().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    supportInfoResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the lab plan.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LabPlanMapper : ResourceMapper<LabPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.labservices.LabPlan::class == javaResource::class

    override fun map(javaResource: Resource): LabPlan = LabPlan(
        javaResource as
            com.pulumi.azurenative.labservices.LabPlan,
    )
}

/**
 * @see [LabPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LabPlan].
 */
public suspend fun labPlan(name: String, block: suspend LabPlanResourceBuilder.() -> Unit):
    LabPlan {
    val builder = LabPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LabPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun labPlan(name: String): LabPlan {
    val builder = LabPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
