@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.labservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
 */
public enum class SkuTier(
    public val javaValue: com.pulumi.azurenative.labservices.enums.SkuTier,
) : ConvertibleToJava<com.pulumi.azurenative.labservices.enums.SkuTier> {
    Free(com.pulumi.azurenative.labservices.enums.SkuTier.Free),
    Basic(com.pulumi.azurenative.labservices.enums.SkuTier.Basic),
    Standard(com.pulumi.azurenative.labservices.enums.SkuTier.Standard),
    Premium(com.pulumi.azurenative.labservices.enums.SkuTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.labservices.enums.SkuTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.labservices.enums.SkuTier): SkuTier =
            SkuTier.values().first { it.javaValue == javaType }
    }
}
